/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWCascadeQueryInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWSQLPreLoadMetadataFilter
implements IDWSQLFilter {
    private static Log log = LogFactory.getLog(DWSQLPreLoadMetadataFilter.class);

    @Override
    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
    }

    @Override
    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
        this.tryLoadMetadata(queryInfo.getTableName());
        if (options instanceof DWDataSetOperationOption) {
            List<DWCascadeQueryInfo> cascadeQueryInfoList = ((DWDataSetOperationOption)options).getCascadingQueryList();
            cascadeQueryInfoList.stream().forEach(c -> this.tryLoadMetadata(c.getReference()));
        }
    }

    private void tryLoadMetadata(String name) {
        try {
            if (DWMetadataContainer.get((String)name) == null) {
                DWMetadataContainer.get((String)name, DWRdbmsMetadata.class);
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("DWSQLPreLoadMetadataFilter  try load metadata(name=%s) failed!", name), (Throwable)e);
        }
    }

    @Override
    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
    }
}

