/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource;

import com.digiwin.app.dao.datasource.DWAbstractTenantDataSource;
import com.digiwin.app.dao.datasource.utils.DWMultipleDataSourcePropertiesUtil;
import com.digiwin.app.module.DWModuleClassLoader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class DWTenantDataSourceByFile
extends DWAbstractTenantDataSource {
    private static Log log = LogFactory.getLog(DWTenantDataSourceByFile.class);
    private static String _CLASSTAG = "[DWTenantDataSourceByFile] ";
    private String columnDsName = "dsname";
    private String columnDsUrl = "dsurl";
    private String columnDsUsername = "username";
    private String columnDsPassword = "password";
    private String columnDsClassName = "dsclassname";
    private String columnDsConnectionProperties = "connectionproperties";

    public DWTenantDataSourceByFile() {
        this.initialize();
    }

    @Override
    public void initialize() {
        String currentModuleName = DWModuleClassLoader.getCurrentModuleName();
        this.initialize(currentModuleName);
    }

    @Override
    public void initialize(String moduleName) {
        boolean isConfigData = false;
        boolean isTenantData = false;
        Properties dataSourceConfig = DWMultipleDataSourcePropertiesUtil.getMultipleDataSourceConfig(moduleName);
        List<Map<String, Object>> dbList = this.getDataSource(dataSourceConfig);
        if (dbList != null && dbList.size() > 0) {
            isConfigData = true;
            HashMap<Object, QueryRunner> tempDataSources = new HashMap<Object, QueryRunner>();
            for (Map<String, Object> row : dbList) {
                BasicDataSource basicDataSource = new BasicDataSource();
                basicDataSource.setDriverClassName((String)row.get(this.columnDsClassName));
                basicDataSource.setUrl((String)row.get(this.columnDsUrl));
                basicDataSource.setUsername((String)row.get(this.columnDsUsername));
                basicDataSource.setPassword((String)row.get(this.columnDsPassword));
                String connectionOptions = (String)row.get(this.columnDsConnectionProperties);
                if (StringUtils.isNotBlank((CharSequence)connectionOptions)) {
                    this.connConfigHandle(basicDataSource, connectionOptions);
                }
                TransactionAwareDataSourceProxy transactionAwareDataSourceProxy = new TransactionAwareDataSourceProxy((DataSource)basicDataSource);
                QueryRunner queryRunner = new QueryRunner((DataSource)transactionAwareDataSourceProxy);
                tempDataSources.put(row.get(this.columnDsName), queryRunner);
                log.debug((Object)(_CLASSTAG + " found dsname:" + row.get(this.columnDsName)));
            }
            this.dataSources = tempDataSources;
        } else {
            log.debug((Object)(_CLASSTAG + "no data in datasourceConfig"));
        }
        if (isConfigData) {
            Properties tenantProperties = DWMultipleDataSourcePropertiesUtil.getMultipleDataSourceTenant(moduleName);
            this.dataSourceTenants = this.getDataSourceTenant(tenantProperties);
            if (this.dataSourceTenants != null && ((Map)this.dataSourceTenants).size() > 0) {
                isTenantData = true;
            } else {
                log.debug((Object)(_CLASSTAG + "no data in datasourceTenant"));
            }
        }
        if (isConfigData && isTenantData) {
            this.multipleDatasouce = true;
        }
    }

    public List<Map<String, Object>> getDataSource(Properties properties) {
        ArrayList<Map<String, Object>> dbList = new ArrayList<Map<String, Object>>();
        for (Object key : properties.keySet()) {
            String dsName = (String)key;
            String rawValue = properties.getProperty(dsName, null);
            String[] values = rawValue.split(",");
            HashMap<String, String> db = new HashMap<String, String>();
            db.put(this.columnDsName, (String)key);
            db.put(this.columnDsUrl, values[0]);
            db.put(this.columnDsUsername, values[1]);
            db.put(this.columnDsPassword, values[2]);
            db.put(this.columnDsClassName, values[3]);
            if (values.length > 4) {
                db.put(this.columnDsConnectionProperties, values[4]);
            } else {
                db.put(this.columnDsConnectionProperties, "");
            }
            dbList.add(db);
        }
        return dbList;
    }

    public Object getDataSourceTenant(Properties properties) {
        HashMap<BigInteger, String> dbList = new HashMap<BigInteger, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String tenantsid = (String)entry.getKey();
            String dsName = (String)entry.getValue();
            dbList.put(new BigInteger(tenantsid), dsName);
        }
        return dbList;
    }
}

