/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.dbutils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import jakarta.xml.bind.DatatypeConverter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class Aes {
    public static String getKey() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String appId = DWApplicationConfigUtils.getProperty((String)"appId", (String)"");
        if (StringUtils.isBlank((CharSequence)appId)) {
            throw new IllegalArgumentException("no appId");
        }
        String first = appId.substring(0, 1).toUpperCase();
        String middle = appId.substring(1, appId.length() - 1);
        String last = appId.substring(appId.length() - 1, appId.length()).toUpperCase();
        String key = last + middle + first;
        String onceMd5 = Aes.md5(key);
        String twiceMd5 = Aes.md5(onceMd5);
        return twiceMd5;
    }

    public static String decrypt(String hex) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        int length = hex.length();
        byte[] ciphertextBytes = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            ciphertextBytes[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        byte[] keyBytes = new byte[16];
        int i = 0;
        String key = Aes.getKey();
        for (byte b : key.getBytes("UTF-8")) {
            int n = i++ % 16;
            keyBytes[n] = (byte)(keyBytes[n] ^ b);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKeySpec);
        byte[] plaintextBytes = cipher.doFinal(ciphertextBytes);
        String plaintext = new String(plaintextBytes, "UTF-8");
        return plaintext;
    }

    private static String md5(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(text.getBytes("UTF-8"));
        byte[] digest = messageDigest.digest();
        String md5 = DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
        return md5;
    }
}

