/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class DWAutoIncrementOption {
    private List<DWAutoIncrementSource> sourceInfos = new ArrayList<DWAutoIncrementSource>();

    public DWAutoIncrementSource addSource(String sourceTableName, String targetTableName) {
        return this.addSource(sourceTableName, null, targetTableName, null);
    }

    public DWAutoIncrementSource addSource(String sourceTableName, String targetTableName, String targetColumnName) {
        return this.addSource(sourceTableName, null, targetTableName, targetColumnName);
    }

    public DWAutoIncrementSource addSource(String sourceTableName, String sourceColumnName, String targetTableName, String targetColumnName) {
        DWAutoIncrementSource returnSource;
        DWAutoIncrementSource newSource = new DWAutoIncrementSource(sourceTableName, sourceColumnName, targetTableName, targetColumnName);
        Optional<DWAutoIncrementSource> currentSourceOptional = this.sourceInfos.stream().filter(i -> i.getSourceTable().equalsIgnoreCase(newSource.getSourceTable()) && i.getTargetTable().equalsIgnoreCase(newSource.getTargetTable())).findFirst();
        if (currentSourceOptional.isPresent()) {
            returnSource = currentSourceOptional.get().addAllColumnMappings(newSource);
        } else {
            returnSource = newSource;
            this.sourceInfos.add(newSource);
        }
        return returnSource;
    }

    public List<DWAutoIncrementSource> getSources() {
        return Collections.unmodifiableList(this.sourceInfos);
    }

    public DWAutoIncrementSource getSource(String targetTableName) {
        if (targetTableName == null) {
            return null;
        }
        Optional<DWAutoIncrementSource> optional = this.sourceInfos.stream().filter(item -> item.getTargetTable().equalsIgnoreCase(targetTableName.toLowerCase())).findFirst();
        return optional.orElse(null);
    }

    public class DWAutoIncrementSource {
        private String sourceTable;
        private String targetTable;
        private DWAutoIncrementValueProxy[] values = null;
        private Map<String, String> columnMappings = new HashMap<String, String>();

        public String getSourceTable() {
            return this.sourceTable;
        }

        public String getTargetTable() {
            return this.targetTable;
        }

        public DWAutoIncrementSource(String sourceTableName, String targetTableName) {
            this(sourceTableName, null, targetTableName, null);
        }

        public DWAutoIncrementSource(String sourceTableName, String targetTableName, String targetColumnName) {
            this(sourceTableName, null, targetTableName, targetColumnName);
        }

        public DWAutoIncrementSource(String sourceTableName, String sourceColumnName, String targetTableName, String targetColumnName) {
            DWRdbmsMetadata targetMetadata;
            if (sourceTableName == null || sourceTableName.isEmpty()) {
                throw new IllegalArgumentException("sourceTableName is null or empty!");
            }
            if (targetTableName == null || targetTableName.isEmpty()) {
                throw new IllegalArgumentException("targetTableName is null or empty!");
            }
            DWRdbmsMetadata sourceMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)sourceTableName, DWRdbmsMetadata.class);
            if (sourceColumnName == null || sourceColumnName.isEmpty()) {
                String autoIncrement = sourceMetadata.getAutoIncrement();
                if (autoIncrement == null) {
                    throw new DWDataException("13019", String.format("Source table(%s) has no Auto Increment definition!", sourceTableName));
                }
                sourceColumnName = autoIncrement;
            }
            if (!sourceMetadata.hasField(sourceColumnName)) {
                throw new DWDataException("13020", String.format("Source table(%s) has no field(%s) for get Auto Increment value!", sourceTableName, sourceColumnName));
            }
            if (targetColumnName == null) {
                targetColumnName = sourceColumnName;
            }
            if (!(targetMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)targetTableName, DWRdbmsMetadata.class)).hasField(targetColumnName)) {
                throw new DWDataException("13021", String.format("Target table(%s) has no field(%s) for apply Auto Increment value!", targetTableName, targetColumnName));
            }
            if (targetTableName == null || targetTableName.isEmpty()) {
                throw new IllegalArgumentException("targetTableName is null or empty!");
            }
            if (targetColumnName == null || targetColumnName.isEmpty()) {
                throw new IllegalArgumentException("targetColumnName is null or empty!");
            }
            this.sourceTable = sourceTableName;
            this.targetTable = targetTableName;
            this.addColumnMapping(sourceColumnName, targetColumnName);
        }

        protected DWAutoIncrementSource addAllColumnMappings(DWAutoIncrementSource otherSource) {
            if (otherSource == null || this == otherSource) {
                return this;
            }
            Map<String, String> otherSourceMappings = otherSource.getColumnMappings();
            for (Map.Entry<String, String> item : otherSourceMappings.entrySet()) {
                this.addColumnMapping(item.getKey(), item.getValue());
            }
            return this;
        }

        public DWAutoIncrementSource addColumnMapping(String sourceColumnName, String targetColumnName) {
            if (sourceColumnName == null || sourceColumnName.isEmpty()) {
                throw new IllegalArgumentException("sourceColumnName is null or empty!");
            }
            if (targetColumnName == null || targetColumnName.isEmpty()) {
                throw new IllegalArgumentException("targetColumnName is null or empty!");
            }
            sourceColumnName = sourceColumnName.toLowerCase();
            targetColumnName = targetColumnName.toLowerCase();
            if (this.columnMappings.containsKey(sourceColumnName)) {
                throw new IllegalArgumentException(String.format("source column name(%s) is already exist!", sourceColumnName));
            }
            if (this.columnMappings.containsValue(targetColumnName)) {
                String existingMappingSource = null;
                for (Map.Entry<String, String> item : this.columnMappings.entrySet()) {
                    if (!item.getValue().equals(targetColumnName)) continue;
                    existingMappingSource = item.getKey();
                }
                throw new IllegalArgumentException(String.format("target column name(%s) is already mapping to source column name(%s)!", targetColumnName, existingMappingSource));
            }
            if (this.values != null) {
                this.values = null;
            }
            this.columnMappings.put(sourceColumnName, targetColumnName);
            return this;
        }

        public Map<String, String> getColumnMappings() {
            return Collections.unmodifiableMap(this.columnMappings);
        }

        public DWAutoIncrementValueProxy[] getValues() {
            if (this.values == null) {
                this.values = new DWAutoIncrementValueProxy[this.columnMappings.size()];
                int i = 0;
                for (Map.Entry<String, String> item : this.columnMappings.entrySet()) {
                    DWAutoIncrementValueProxy value = new DWAutoIncrementValueProxy(DWAutoIncrementOption.this, this, item.getKey(), item.getValue());
                    this.values[i++] = value;
                }
            }
            return this.values;
        }
    }

    public class DWAutoIncrementValueProxy {
        private DWAutoIncrementSource owner;
        private String sourceColumn;
        private String targetColumn;

        DWAutoIncrementValueProxy(DWAutoIncrementOption this$0, DWAutoIncrementSource owner, String sourceColumnName, String targetColumnName) {
            this.owner = owner;
            this.sourceColumn = sourceColumnName;
            this.targetColumn = targetColumnName;
        }

        public String getSourceColumn() {
            return this.sourceColumn;
        }

        public String getTargetColumn() {
            return this.targetColumn;
        }

        public Object applyValue(DWDataRow sourceRow, DWDataRow targetRow) {
            return this.applyValue(sourceRow, Collections.singletonList(targetRow));
        }

        public Object applyValue(DWDataRow sourceRow, List<DWDataRow> targetRows) {
            String sourceRowTableName = sourceRow.getDataTable().getName();
            String targetRowTableName = targetRows.get(0).getDataTable().getName();
            if (!this.owner.sourceTable.equalsIgnoreCase(sourceRowTableName)) {
                throw new IllegalArgumentException(String.format("target row(%s) table is (%s), but the auto increment source table is (%s)!", targetRows.get(0), sourceRowTableName, this.owner.sourceTable));
            }
            if (!this.owner.targetTable.equalsIgnoreCase(targetRowTableName)) {
                throw new IllegalArgumentException(String.format("target row(%s) table is (%s), but the auto increment target table is (%s)!", targetRows.get(0), targetRowTableName, this.owner.targetTable));
            }
            Object sourceCellvalue = sourceRow.get(this.sourceColumn);
            ((Stream)targetRows.stream().parallel()).forEach(row -> row.set(this.targetColumn, sourceCellvalue));
            return sourceCellvalue;
        }
    }
}

