/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dashboard.weather;

import com.digiwin.app.dashboard.service.impl.WeatherService;
import com.digiwin.app.dashboard.weather.IWeatherProvider;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class DefaultWeatherProvider
implements IWeatherProvider {
    private static final Log _log = LogFactory.getLog(WeatherService.class);
    private String baseUrl;
    private String queryString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String queryString) throws Exception {
        String url = this.baseUrl + queryString;
        URI targetUri = new URI(url);
        HttpGet httpRequest = new HttpGet(targetUri);
        HashMap<String, Object> returnResult = null;
        try {
            HashMap<String, Object> entity;
            DWHttpClient httpClient = new DWHttpClient();
            returnResult = entity = (HashMap<String, Object>)httpClient.execute((HttpUriRequest)httpRequest, Map.class, (Supplier)this.getHeader());
        }
        catch (DWHttpFailedException e) {
            Map entity = (Map)e.getEntity(Map.class);
            StringBuilder msg = new StringBuilder();
            msg.append(String.format("httpClient execute failed! return status=%s", e.getStatusCode()));
            msg.append(String.format("...message=%s", entity.get("message")));
            _log.error((Object)msg, (Throwable)e);
            HashMap<String, Object> expMap = new HashMap<String, Object>();
            expMap.put("success", false);
            expMap.put("message", msg.toString());
            returnResult = expMap;
        }
        return returnResult;
    }

    private Object getHeader() {
        final Map myHeaders = DWRequestHeaderUtils.getIamApiRequiredHeaders();
        myHeaders.remove("digi-middleware-auth-app");
        Supplier<Map<String, String>> headerSupplier = new Supplier<Map<String, String>>(){

            @Override
            public Map<String, String> get() {
                return myHeaders;
            }
        };
        return headerSupplier;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }
}

