/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.service;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionElementDeserializer;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;

public class DWDataPermission {
    public static final String IAM_DATAPERMISSION_API2 = "/api/iam/v2/permission/data";
    private static Gson customGson = null;

    private static synchronized Gson getCustomGson() {
        if (customGson == null) {
            GsonBuilder builder = new GsonBuilder().serializeNulls();
            builder.registerTypeAdapter(DWRowPermissionElement.class, (Object)new DWRowPermissionElementDeserializer());
            customGson = builder.create();
        }
        return customGson;
    }

    public static Object getDataPermission(String moduleId, String actionId) throws Exception {
        String userToken = DWServiceContext.getContext().getToken();
        String appId = DWApplicationConfigUtils.getProperty((String)"appId");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sysId", appId);
        params.put("moduleId", moduleId);
        params.put("actionId", actionId);
        ServiceModel serviceModel = new ServiceModel();
        serviceModel.setInvokeURL(IAM_DATAPERMISSION_API2);
        serviceModel.setParams(params);
        serviceModel.setToken(userToken);
        HttpResponseModel iamResponseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)serviceModel);
        String iamResponseBody = iamResponseModel.getResponseBody();
        int iamResponseStatusCode = iamResponseModel.getHttpStatusCode();
        if (iamResponseStatusCode != 200) {
            String errorMessage = "IAM\u56de\u50b3\u72c0\u614b\u78bc\u70ba:%s, \u932f\u8aa4\u8a0a\u606f\u70ba:%s";
            throw new DWException(String.format(errorMessage, iamResponseStatusCode, errorMessage));
        }
        Gson gson = DWDataPermission.getCustomGson();
        DWUserPermission userPermission = (DWUserPermission)gson.fromJson(iamResponseBody, DWUserPermission.class);
        return userPermission;
    }
}

