/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWDataPermissionOption;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWUserPermission;
import com.digiwin.data.service.DWDataPermission;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDataPermissionSQLFilter
implements IDWSQLFilter {
    private static Log log = LogFactory.getLog(DWDataPermissionSQLFilter.class);
    public static final String OPTION_MODULE_ID = "moduleId";
    public static final String OPTION_ACTION_ID = "actionId";
    public static final String OPTION_API = "api";
    public static final String TAG_DATA_PERM = "${dataPerm}";
    private static final String _matchQuoteEmpty = Matcher.quoteReplacement(" ");

    public DWUserPermission getDataPermission(IDWSQLOptions options) throws Exception {
        DWUserPermission result = null;
        String api = null;
        String moduleId = null;
        String actionId = null;
        if (options instanceof DWDataPermissionOption) {
            DWDataPermissionOption dataPermOption = (DWDataPermissionOption)options;
            api = dataPermOption.getApi();
            moduleId = dataPermOption.getModuleId();
            actionId = dataPermOption.getActionId();
        } else {
            DWServiceContext serviceContext = DWServiceContext.getContext();
            Map requestHeader = serviceContext.getRequestHeader();
            if (requestHeader.containsKey(OPTION_MODULE_ID)) {
                moduleId = requestHeader.get(OPTION_MODULE_ID).toString();
            }
            if (requestHeader.containsKey(OPTION_ACTION_ID)) {
                actionId = requestHeader.get(OPTION_ACTION_ID).toString();
            }
            if (serviceContext.getAllowCrossTenant()) {
                api = serviceContext.getRequestURI();
            }
        }
        if (api != null) {
            if (api.startsWith("/")) {
                api = api.substring(1);
            }
            result = (DWUserPermission)DWDataPermission.getDataPermission(api);
        } else if (actionId != null && moduleId != null) {
            result = (DWUserPermission)DWDataPermission.getDataPermission(moduleId, actionId);
        }
        return result;
    }

    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        String sqlcommand = sqlInfo.getSql();
        List parameters = sqlInfo.getParametersAsList();
        if (sqlcommand.contains(TAG_DATA_PERM)) {
            String rowPermissionSql;
            log.debug((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)],before sql command:" + sqlcommand));
            DWUserPermission dataPermData = null;
            try {
                dataPermData = this.getDataPermission(options);
            }
            catch (Exception e) {
                log.error((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)], exception message=" + e.getMessage()));
            }
            sqlcommand = dataPermData != null ? ((rowPermissionSql = dataPermData.getRowPermission().getSQLContainValues(new DWRowPermissionDefaultMatchOption())) != null && !rowPermissionSql.isEmpty() ? sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), Matcher.quoteReplacement(" and " + rowPermissionSql)) : sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), _matchQuoteEmpty)) : sqlcommand.replaceAll(Pattern.quote(TAG_DATA_PERM), _matchQuoteEmpty);
            log.debug((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)],after sql command:" + sqlcommand));
            sqlInfo.setSqlAndParameters(sqlcommand, parameters);
        }
    }

    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
        DWUserPermission dataPermData = null;
        try {
            dataPermData = this.getDataPermission(options);
        }
        catch (Exception e) {
            log.error((Object)("[DWDataPermissionSQLFilter.doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options)], e=" + e.getMessage()));
        }
        if (dataPermData != null) {
            DWQueryCondition queryCondition = dataPermData.getRowPermission().getQueryCondition(new DWRowPermissionDefaultMatchOption());
            DWQueryCondition fixedCondition = queryInfo.getFixedCondition();
            fixedCondition.addCondition(queryCondition);
        }
    }

    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
    }
}

