/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.data.permission.DWPermissionOperatorProcessor;
import com.digiwin.data.permission.DWRowPermissionBase;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWRowPermissionField
extends DWRowPermissionBase {
    private static Log log = LogFactory.getLog(DWRowPermissionField.class);
    private String filterTable;
    private String filterField;
    private String fieldName;
    private String filterType;
    private String dataType;
    private List<Object> filterValue;

    public String getFilterTable() {
        return this.filterTable;
    }

    public void setFilterTable(String filterTable) {
        this.filterTable = filterTable;
    }

    public String getFilterField() {
        return this.filterField;
    }

    public void setFilterField(String filterField) {
        this.filterField = filterField;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public List<Object> getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(List<Object> filterValue) {
        this.filterValue = filterValue;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public String getFilterType() {
        return this.filterType;
    }

    @Override
    protected <T> List<T> filterCore(List<? extends Object> datas, DWRowPermissionMatchOption option) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : datas) {
            if (!this.isMatch(object, option)) continue;
            result.add(object);
        }
        return result;
    }

    @Override
    protected boolean isMatchCore(Object data, DWRowPermissionMatchOption option) {
        if (data == null) {
            return false;
        }
        if (option != null && !option.isValidFilterField(this.filterField)) {
            log.warn((Object)("User row permission contains invalid filter filed '" + this.filterField + "', it could casue unexpected match result!"));
            return true;
        }
        if (data instanceof Map) {
            return this.mapObjectCompareValue((Map)data, option);
        }
        try {
            return this.reflectionCompareValue(data, option);
        }
        catch (Exception e) {
            throw new RuntimeException("isMatch failed!", e);
        }
    }

    private boolean mapObjectCompareValue(Map<String, Object> data, DWRowPermissionMatchOption option) {
        String conversionLookupKey = option == null ? this.filterField : option.getRealDataField(this.filterField);
        Optional<String> result = data.keySet().stream().filter((? super T key) -> key.equalsIgnoreCase(conversionLookupKey)).findFirst();
        if (!result.isPresent()) {
            throw new IllegalArgumentException("Unknown field '" + this.filterField + "' in data!");
        }
        String actualMapKey = result.get();
        Object actualValue = data.get(actualMapKey);
        return DWPermissionOperatorProcessor.execute(actualValue, this.filterType, this.filterValue);
    }

    private boolean reflectionCompareValue(Object data, DWRowPermissionMatchOption option) throws Exception {
        Field[] fields;
        String conversionLookupKey = option == null ? this.filterField : option.getRealDataField(this.filterField);
        Field targetField = null;
        for (Field field : fields = data.getClass().getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(conversionLookupKey)) continue;
            targetField = field;
            break;
        }
        if (targetField == null) {
            throw new IllegalArgumentException("Unknown field '" + this.filterField + "' in data!");
        }
        targetField.setAccessible(true);
        Object actualValue = targetField.get(data);
        return DWPermissionOperatorProcessor.execute(actualValue, this.filterType, this.filterValue);
    }

    @Override
    public DWSqlInfo getSQLCore(DWRowPermissionMatchOption option) {
        return DWPermissionOperatorProcessor.getSQL(this.filterField, this.filterType, this.filterValue, option);
    }

    @Override
    public String getSQLContainValuesCore(DWRowPermissionMatchOption option) {
        return DWPermissionOperatorProcessor.getSQLContainValues(this.filterField, this.filterType, this.filterValue, option);
    }

    @Override
    public DWQueryCondition getQueryConditionCore(DWRowPermissionMatchOption option) {
        return DWPermissionOperatorProcessor.getQueryInfo(this.filterField, this.filterType, this.filterValue, option);
    }
}

