/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.data.permission.DWPermissionOperatorProcessor;
import com.digiwin.data.permission.DWRowPermissionBase;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permisson.row.processor.DWPermissionFilterValueProcessorChain;
import com.digiwin.data.permisson.row.processor.DWPermissionTableAndFieldProcessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWRowPermissionField<T>
extends DWRowPermissionBase<T> {
    private static Log log = LogFactory.getLog(DWRowPermissionField.class);

    @Override
    protected <T> List<T> filterCore(List<? extends Object> datas, DWRowPermissionMatchOption option) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : datas) {
            if (!this.isMatch(object, option)) continue;
            result.add(object);
        }
        return result;
    }

    @Override
    protected boolean isMatchCore(Object data, DWRowPermissionMatchOption option) {
        if (data == null) {
            return false;
        }
        if (option != null && !option.isValidFilterField(this.filterField)) {
            log.warn((Object)("User row permission contains invalid filter filed '" + this.filterField + "', it could casue unexpected match result!"));
            return true;
        }
        if (data instanceof Map) {
            return this.mapObjectCompareValue((Map)data, option);
        }
        try {
            return this.reflectionCompareValue(data, option);
        }
        catch (Exception e) {
            throw new RuntimeException("isMatch failed!", e);
        }
    }

    private boolean mapObjectCompareValue(Map<String, Object> data, DWRowPermissionMatchOption option) {
        String conversionLookupKey = option == null ? this.filterField : option.getRealDataField(this.filterTable, this.filterField);
        Optional<String> result = data.keySet().stream().filter((? super T key) -> key.equalsIgnoreCase(conversionLookupKey)).findFirst();
        if (!result.isPresent()) {
            throw new IllegalArgumentException("Unknown field '" + this.filterField + "' in data!");
        }
        String actualMapKey = result.get();
        Object actualValue = data.get(actualMapKey);
        return DWPermissionOperatorProcessor.execute(actualValue, this.filterType, this.getFilterValue(option));
    }

    private boolean reflectionCompareValue(Object data, DWRowPermissionMatchOption option) throws Exception {
        Field[] fields;
        String conversionLookupKey = option == null ? this.filterField : option.getRealDataField(this.filterTable, this.filterField);
        Field targetField = null;
        for (Field field : fields = data.getClass().getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(conversionLookupKey)) continue;
            targetField = field;
            break;
        }
        if (targetField == null) {
            throw new IllegalArgumentException("Unknown field '" + this.filterField + "' in data!");
        }
        targetField.setAccessible(true);
        Object actualValue = targetField.get(data);
        return DWPermissionOperatorProcessor.execute(actualValue, this.filterType, this.getFilterValue(option));
    }

    @Override
    public DWSqlInfo getSQLCore(DWRowPermissionMatchOption option) {
        String processedFieldName = DWPermissionTableAndFieldProcessor.processTableAndField(option, this);
        List filterValues = this.getFilterValue(option);
        List<?> convertedFilterValues = DWPermissionFilterValueProcessorChain.processFilterValue(option, this, filterValues);
        return DWPermissionOperatorProcessor.getSQL(processedFieldName, this.filterType, convertedFilterValues, option);
    }

    @Override
    public String getSQLContainValuesCore(DWRowPermissionMatchOption option) {
        String processedFieldName = DWPermissionTableAndFieldProcessor.processTableAndField(option, this);
        List filterValues = this.getFilterValue(option);
        List<?> convertedFilterValues = DWPermissionFilterValueProcessorChain.processFilterValue(option, this, filterValues);
        return DWPermissionOperatorProcessor.getSQLContainValues(processedFieldName, this.filterType, convertedFilterValues, option);
    }

    @Override
    public DWQueryCondition getQueryConditionCore(DWRowPermissionMatchOption option) {
        String processedFieldName = DWPermissionTableAndFieldProcessor.processTableAndField(option, this);
        List filterValues = this.getFilterValue(option);
        List<?> convertedFilterValues = DWPermissionFilterValueProcessorChain.processFilterValue(option, this, filterValues);
        return DWPermissionOperatorProcessor.getQueryInfo(processedFieldName, this.filterType, convertedFilterValues, option);
    }
}

