/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.data.permission.DWRowPermissionBase;
import com.digiwin.data.permission.DWRowPermissionElement;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import com.digiwin.data.permission.DWRowPermissionSQLConditionNode;
import java.util.ArrayList;
import java.util.List;

public class DWRowPermissionGroup
extends DWRowPermissionBase
implements DWRowPermissionSQLConditionNode {
    private static final String FILTER_TYPE_AND = "and";
    private static final String FILTER_TYPE_OR = "or";
    private String filterType = "and";
    private List<DWRowPermissionElement> filterValue;

    public String getFilterType() {
        return this.filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public List<DWRowPermissionElement> getFilterValue() {
        if (this.filterValue == null) {
            new ArrayList();
        }
        return this.filterValue;
    }

    public void setFilterValue(List<DWRowPermissionElement> filterValue) {
        this.filterValue = filterValue;
    }

    @Override
    protected <T> List<T> filterCore(List<? extends Object> datas, DWRowPermissionMatchOption option) {
        ArrayList<Object> matchedDatas = new ArrayList<Object>();
        if (datas == null) {
            return matchedDatas;
        }
        for (Object object : datas) {
            if (!this.isMatch(object, option)) continue;
            matchedDatas.add(object);
        }
        return matchedDatas;
    }

    @Override
    protected boolean isMatchCore(Object data, DWRowPermissionMatchOption option) {
        if (this.filterValue == null || this.filterValue.isEmpty()) {
            return true;
        }
        if (FILTER_TYPE_AND.equalsIgnoreCase(this.filterType)) {
            for (DWRowPermissionElement item : this.filterValue) {
                if (item.isMatch(data, option)) continue;
                return false;
            }
            return true;
        }
        if (FILTER_TYPE_OR.equalsIgnoreCase(this.filterType)) {
            for (DWRowPermissionElement item : this.filterValue) {
                if (!item.isMatch(data, option)) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("unknown filter type -> " + this.filterType);
    }

    private String getJoinOperator() {
        if (FILTER_TYPE_AND.equalsIgnoreCase(this.filterType) || FILTER_TYPE_OR.equalsIgnoreCase(this.filterType)) {
            return this.filterType.toUpperCase();
        }
        throw new RuntimeException("unknown filter type -> " + this.filterType);
    }

    @Override
    public DWSqlInfo getSQLCore(DWRowPermissionMatchOption option) {
        StringBuilder sql = new StringBuilder();
        ArrayList params = new ArrayList();
        List<DWRowPermissionElement> items = this.getFilterValue();
        if (items == null) {
            return new DWSqlInfo("", params);
        }
        int seq = 0;
        for (DWRowPermissionElement item : items) {
            DWSqlInfo subSqlInfo = item.getSQL(option);
            if (subSqlInfo == null || subSqlInfo.getSql() == null || subSqlInfo.getSql().isEmpty()) continue;
            if (++seq != 1) {
                sql.append(" ").append(this.getJoinOperator()).append(" ");
            }
            sql.append(subSqlInfo.getSql());
            params.addAll(subSqlInfo.getParametersAsList());
        }
        String mergedSql = sql.toString();
        if (!mergedSql.isEmpty()) {
            mergedSql = "(" + mergedSql + ")";
        }
        return new DWSqlInfo(mergedSql, params);
    }

    @Override
    public String getSQLContainValuesCore(DWRowPermissionMatchOption option) {
        StringBuilder sql = new StringBuilder();
        List<DWRowPermissionElement> items = this.getFilterValue();
        if (items == null) {
            return "";
        }
        int seq = 0;
        for (DWRowPermissionElement item : items) {
            String itemSql = item.getSQLContainValues(option);
            if (itemSql == null || itemSql.isEmpty()) continue;
            if (++seq != 1) {
                sql.append(" ").append(this.getJoinOperator()).append(" ");
            }
            sql.append(itemSql);
        }
        String mergedSql = sql.toString();
        if (!mergedSql.isEmpty()) {
            mergedSql = "(" + mergedSql + ")";
        }
        return mergedSql;
    }

    @Override
    public DWQueryCondition getQueryConditionCore(DWRowPermissionMatchOption option) {
        DWQueryCondition queryCondition = new DWQueryCondition();
        List<DWRowPermissionElement> items = this.getFilterValue();
        if (items == null) {
            return new DWQueryCondition();
        }
        if (FILTER_TYPE_AND.equalsIgnoreCase(this.getFilterType())) {
            queryCondition.ANDJoin();
        } else if (FILTER_TYPE_OR.equalsIgnoreCase(this.getFilterType())) {
            queryCondition.ORJoin();
        }
        for (DWRowPermissionElement item : items) {
            DWQueryCondition itemQueryCondition = item.getQueryCondition(option);
            if (itemQueryCondition.size() == 0) continue;
            queryCondition.addCondition(itemQueryCondition);
        }
        return queryCondition;
    }
}

