/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.data.permission.DWPermissionOperator;
import com.digiwin.data.permission.DWRowPermissionDefaultMatchOption;
import com.digiwin.data.permission.DWRowPermissionMatchOption;
import java.util.List;

public abstract class DWPermissionCondition {
    private static final String FIELD_IS_NULL = "fieldName is null or empty!";
    private static final String CONDITION_IS_NULL = "conditionValues is null or empty!";

    protected abstract boolean isSupport(DWPermissionOperator var1);

    public boolean isMatch(Object data, DWPermissionOperator operator, List<? extends Object> conditionValues) {
        if (operator == null) {
            throw new DWRuntimeException("operator", "operator is null!");
        }
        if (!this.isSupport(operator)) {
            throw new DWRuntimeException(this.getClass() + " is not support this operator -> " + (Object)((Object)operator));
        }
        return this.matchCore(data, operator, conditionValues);
    }

    protected abstract boolean matchCore(Object var1, DWPermissionOperator var2, List<? extends Object> var3);

    public DWSqlInfo getSQL(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException(FIELD_IS_NULL);
        }
        if (conditionValues == null || conditionValues.isEmpty()) {
            throw new IllegalArgumentException(CONDITION_IS_NULL);
        }
        if (option == null) {
            option = new DWRowPermissionDefaultMatchOption();
        }
        String realName = option.getRealDataField(fieldName);
        return this.getSQLCore(realName, operator, conditionValues, option);
    }

    protected abstract DWSqlInfo getSQLCore(String var1, DWPermissionOperator var2, List<? extends Object> var3, DWRowPermissionMatchOption var4);

    public String getSQLContainValues(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException(FIELD_IS_NULL);
        }
        if (conditionValues == null || conditionValues.isEmpty()) {
            throw new IllegalArgumentException(CONDITION_IS_NULL);
        }
        if (option == null) {
            option = new DWRowPermissionDefaultMatchOption();
        }
        String realName = option.getRealDataField(fieldName);
        return this.getSQLContainValuesCore(realName, operator, conditionValues, option);
    }

    protected abstract String getSQLContainValuesCore(String var1, DWPermissionOperator var2, List<? extends Object> var3, DWRowPermissionMatchOption var4);

    protected DWQueryCondition getQueryCondition(String fieldName, DWPermissionOperator operator, List<? extends Object> conditionValues, DWRowPermissionMatchOption option) {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException(FIELD_IS_NULL);
        }
        if (conditionValues == null || conditionValues.isEmpty()) {
            throw new IllegalArgumentException(CONDITION_IS_NULL);
        }
        if (option == null) {
            option = new DWRowPermissionDefaultMatchOption();
        }
        String realName = option.getRealDataField(fieldName);
        return this.getQueryConditionCore(realName, operator, conditionValues, option);
    }

    protected abstract DWQueryCondition getQueryConditionCore(String var1, DWPermissionOperator var2, List<? extends Object> var3, DWRowPermissionMatchOption var4);
}

