/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.data.permission;

import com.digiwin.data.permission.row.filtervalue.IDWPermissionFilterValueProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class DWRowPermissionMatchOption {
    private boolean strictMode = true;
    private boolean addTableName = false;
    private Map<String, String> filterNameMappings = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, String> filterTableMappings = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Map<String, String>> filterNameMappingsWithFilterTable = new TreeMap<String, Map<String, String>>(String.CASE_INSENSITIVE_ORDER);
    private List<IDWPermissionFilterValueProcessor> processors = new ArrayList<IDWPermissionFilterValueProcessor>();

    public DWRowPermissionMatchOption() {
        this(true);
    }

    public DWRowPermissionMatchOption(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isAddTableName() {
        return this.addTableName;
    }

    public void setAddTableName(boolean addTableName) {
        this.addTableName = addTableName;
    }

    public DWRowPermissionMatchOption addFilterFieldMapping(String permissionFilterField, String realDataField) {
        this.filterNameMappings.put(permissionFilterField, realDataField);
        return this;
    }

    public DWRowPermissionMatchOption addFilterFieldMapping(String tableName, String permissionFilterField, String realDataField) {
        Map<Object, Object> filterNameMappings;
        if (!this.filterNameMappingsWithFilterTable.containsKey(tableName)) {
            filterNameMappings = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.filterNameMappingsWithFilterTable.put(tableName, filterNameMappings);
        }
        filterNameMappings = this.filterNameMappingsWithFilterTable.get(tableName);
        filterNameMappings.put(permissionFilterField, realDataField);
        return this;
    }

    public String getRealDataField(String filterTable, String permissionFilterField) {
        if (this.filterNameMappingsWithFilterTable.containsKey(filterTable)) {
            Map<String, String> filterNameMappings = this.filterNameMappingsWithFilterTable.get(filterTable);
            if (filterNameMappings.containsKey(permissionFilterField)) {
                return filterNameMappings.get(permissionFilterField);
            }
            return permissionFilterField;
        }
        return this.getRealDataField(permissionFilterField);
    }

    public String getRealDataField(String permissionFilterField) {
        if (this.filterNameMappings.containsKey(permissionFilterField)) {
            return this.filterNameMappings.get(permissionFilterField);
        }
        return permissionFilterField;
    }

    public DWRowPermissionMatchOption addTableNameAlias(String tableName, String alias) {
        this.filterTableMappings.put(tableName, alias);
        this.setAddTableName(true);
        return this;
    }

    public String getRealFilterTable(String filterTable) {
        if (this.filterTableMappings.containsKey(filterTable)) {
            return this.filterTableMappings.get(filterTable);
        }
        return filterTable;
    }

    public abstract boolean isValidFilterField(String var1);

    public void addFieldValueProcessor(IDWPermissionFilterValueProcessor processor) {
        this.processors.add(processor);
    }

    public List<IDWPermissionFilterValueProcessor> getFieldValueProcessor() {
        return this.processors;
    }
}

