/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.agent.reloader;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.dap.agent.reloader.DWBaseClassReloader;
import com.digiwin.dap.agent.util.CommonUtils;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileName;

public class DWModuleClassReloader
extends DWBaseClassReloader {
    public DWModuleClassReloader(Instrumentation javaProgramInstrumentation) {
        super(javaProgramInstrumentation);
    }

    @Override
    protected String getQualifiedName(FileName file) {
        String[] names = CommonUtils.convertFileNameToModuleNameAndQualifiedName(this.getHotLoadingMonitorPaths(), file.getURI());
        System.out.println("reload class:" + names[1]);
        return names[1];
    }

    @Override
    protected ClassLoader getClassLoader(FileName file) {
        String[] names = CommonUtils.convertFileNameToModuleNameAndQualifiedName(this.getHotLoadingMonitorPaths(), file.getURI());
        System.out.println("reload module:" + names[0]);
        return DWModuleClassLoader.getModuleClassLoaderByExactName((String)names[0]);
    }

    @Override
    protected List<String> getHotLoadingMonitorPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(DWPathUtils.getCustomizationModulePath());
        paths.add(DWPathUtils.getIndustryModulePath());
        paths.add(DWPathUtils.getApplicationModulePath());
        return paths;
    }
}

