/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.agent.monitor;

import com.digiwin.dap.agent.monitor.FileChangedInfo;
import com.digiwin.dap.agent.monitor.FileChangedMonitorConfig;
import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;

public class FileChangedMonitor
extends Observable {
    private long frequency;
    private Timer timer;
    private DefaultFileMonitor fileMonitor;
    private FileChangedMonitorConfig config;
    private FileChangedInfo fileChangedInfo;
    private boolean startTask = false;

    public FileChangedMonitor(long frequency, FileChangedMonitorConfig config) {
        this.frequency = frequency;
        this.config = config;
        this.fileChangedInfo = new FileChangedInfo();
        this.timer = new Timer();
        this.initMonitor();
    }

    private void initMonitor() {
        try {
            this.fileMonitor = new DefaultFileMonitor((FileListener)new FileChangeEventHandler());
            FileSystemManager fsm = VFS.getManager();
            this.fileMonitor.setRecursive(true);
            List<String> monitorFilePaths = this.config.getMonitorFilePaths();
            for (String monitorFilePath : monitorFilePaths) {
                FileObject monitorFileObject = fsm.resolveFile(new File(monitorFilePath).getAbsolutePath());
                this.fileMonitor.addFile(monitorFileObject);
            }
        }
        catch (FileSystemException e) {
            System.err.println("init monitor failed");
            System.err.println((Object)e);
        }
    }

    public void runMonitor() {
        this.fileMonitor.start();
        System.out.println("file changed monitor running...");
    }

    private void runTimer() {
        this.setChanged();
        this.timer.schedule((TimerTask)new NotifyTask(), this.frequency * 1000L);
    }

    class NotifyTask
    extends TimerTask {
        NotifyTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileChangedMonitor.this.notifyObservers(FileChangedMonitor.this.fileChangedInfo);
            System.out.println("notify completed...");
            FileChangedMonitor.this.fileChangedInfo.clear();
            NotifyTask notifyTask = this;
            synchronized (notifyTask) {
                FileChangedMonitor.this.startTask = false;
            }
            System.out.println("notify task completed...");
        }
    }

    private class FileChangeEventHandler
    implements FileListener {
        private FileChangeEventHandler() {
        }

        public void fileCreated(FileChangeEvent event) throws Exception {
            this.resolveEvent(FileChangeEventEnum.CREATED, event);
        }

        public void fileDeleted(FileChangeEvent event) throws Exception {
            this.resolveEvent(FileChangeEventEnum.DELETED, event);
        }

        public void fileChanged(FileChangeEvent event) throws Exception {
            this.resolveEvent(FileChangeEventEnum.CHANGED, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveEvent(FileChangeEventEnum type, FileChangeEvent event) {
            try {
                FileName file = event.getFile().getName();
                boolean allowExtension = false;
                for (String monitorFileExtension : FileChangedMonitor.this.config.getMonitorFileExtensions()) {
                    if (!file.getExtension().equals(monitorFileExtension)) continue;
                    allowExtension = true;
                }
                if (!allowExtension) {
                    return;
                }
                switch (type) {
                    case CREATED: {
                        FileChangedMonitor.this.fileChangedInfo.addCreateFile(file);
                        System.out.println("receive file created event, file=" + file.getURI());
                        break;
                    }
                    case DELETED: {
                        FileChangedMonitor.this.fileChangedInfo.addDeletedFile(file);
                        System.out.println("receive file deleted event, file=" + file.getURI());
                        break;
                    }
                    case CHANGED: {
                        FileChangedMonitor.this.fileChangedInfo.addChangedFile(file);
                        System.out.println("receive file changed event, file=" + file.getURI());
                        break;
                    }
                }
                FileChangeEventHandler fileChangeEventHandler = this;
                synchronized (fileChangeEventHandler) {
                    if (!FileChangedMonitor.this.startTask) {
                        FileChangedMonitor.this.runTimer();
                        System.out.println("notify task timer counting...");
                        FileChangedMonitor.this.startTask = true;
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private static enum FileChangeEventEnum {
        CREATED("Created"),
        DELETED("Deleted"),
        CHANGED("Changed");

        private String value;

        private FileChangeEventEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

