/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.agent.reloader;

import com.digiwin.dap.agent.monitor.FileChangedInfo;
import com.digiwin.dap.agent.monitor.FileChangedMonitor;
import com.digiwin.dap.agent.monitor.FileChangedMonitorConfig;
import com.digiwin.dap.agent.util.CommonUtils;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.vfs2.FileName;

public abstract class DWBaseClassReloader
implements Observer {
    private FileChangedMonitor fileChangedMonitor;
    private Instrumentation javaProgramInstrumentation;

    public DWBaseClassReloader(Instrumentation javaProgramInstrumentation) {
        this.javaProgramInstrumentation = javaProgramInstrumentation;
    }

    public void initMonitor() throws Exception {
        FileChangedMonitorConfig fileChangedMonitorConfig = new FileChangedMonitorConfig();
        List<String> hotLoadingPaths = this.getHotLoadingMonitorPaths();
        for (String hotLoadingPath : hotLoadingPaths) {
            fileChangedMonitorConfig.addFilePath(hotLoadingPath);
        }
        fileChangedMonitorConfig.addFileExtension("class");
        System.out.println(this.getClass().getSimpleName() + " monitor paths=" + String.valueOf(fileChangedMonitorConfig.getMonitorFilePaths()));
        System.out.println(this.getClass().getSimpleName() + " monitor extensions=" + String.valueOf(fileChangedMonitorConfig.getMonitorFileExtensions()));
        this.fileChangedMonitor = new FileChangedMonitor(3L, fileChangedMonitorConfig);
    }

    public void runMonitor() {
        this.fileChangedMonitor.addObserver(this);
        this.fileChangedMonitor.runMonitor();
        System.out.println(this.getClass().getSimpleName() + " class reloader monitor running...");
    }

    @Override
    public void update(Observable o, Object arg) {
        FileChangedInfo fileChangedInfo = (FileChangedInfo)arg;
        try {
            List<FileName> createdFiles = fileChangedInfo.getCreateFiles();
            for (FileName createdFile : createdFiles) {
                this.reloadClass(createdFile);
            }
            List<FileName> changedFiles = fileChangedInfo.getChangedFiles();
            for (FileName changedFile : changedFiles) {
                this.reloadClass(changedFile);
            }
        }
        catch (Exception e) {
            System.err.println(this.getClass().getSimpleName() + " class reloader update method error...");
            System.err.println(e);
        }
    }

    protected void reloadClass(FileName file) throws Exception {
        System.out.println(this.getClass().getSimpleName() + " reload file URI:" + file.getURI());
        String qualifiedName = this.getQualifiedName(file);
        System.out.println(this.getClass().getSimpleName() + " reload class:" + qualifiedName);
        ClassLoader classLoader = this.getClassLoader(file);
        Class<?> targetClass = classLoader.loadClass(qualifiedName);
        byte[] targetClassData = CommonUtils.loadFromURI(file.getURI());
        ClassDefinition clazzDef = new ClassDefinition(targetClass, targetClassData);
        this.javaProgramInstrumentation.redefineClasses(clazzDef);
        System.out.println(this.getClass().getSimpleName() + " reload class finished");
    }

    protected abstract String getQualifiedName(FileName var1);

    protected abstract ClassLoader getClassLoader(FileName var1) throws Exception;

    protected abstract List<String> getHotLoadingMonitorPaths();
}

