/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.agent.reloader;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.dap.agent.reloader.DWBaseClassReloader;
import com.digiwin.dap.agent.util.CommonUtils;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileName;

public class DWSystemClassReloader
extends DWBaseClassReloader {
    public DWSystemClassReloader(Instrumentation javaProgramInstrumentation) {
        super(javaProgramInstrumentation);
    }

    @Override
    protected String getQualifiedName(FileName file) {
        return CommonUtils.convertFileNameToQualifiedName(this.getHotLoadingMonitorPaths(), file.getURI());
    }

    @Override
    public void initMonitor() throws Exception {
        super.initMonitor();
        URLClassLoader systemClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURLMethod.setAccessible(true);
        File platformLibFile = new File(DWPathUtils.getPlatformLibPath());
        addURLMethod.invoke((Object)systemClassLoader, platformLibFile.toURI().toURL());
    }

    @Override
    protected ClassLoader getClassLoader(FileName file) throws Exception {
        return this.getClass().getClassLoader();
    }

    @Override
    protected List<String> getHotLoadingMonitorPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(DWPathUtils.getPlatformLibPath());
        return paths;
    }
}

