/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.util;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.util.DocumentIdFormatter;
import com.digiwin.utils.DWTenantUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DocumentIdSetting {
    String tableName;
    String columnName;
    String prefix;
    String group;
    private String pattern = "yyyyMMdd";
    int serialIdLength = 4;
    int year = Calendar.getInstance().get(1);
    int month = Calendar.getInstance().get(2) + 1;
    int day = Calendar.getInstance().get(5);
    int number = 1;
    boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    DWDao dao;
    private String suffix;
    private Map<String, Object> conditions;

    public DocumentIdSetting(String tableName, String columnName) {
        if (tableName == null || tableName.isEmpty() || columnName == null || columnName.isEmpty()) {
            throw new DWDataException("tableName && columnName can't be null");
        }
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public DocumentIdSetting setDate(int year, int month, int day) throws Exception {
        StringBuilder strDate = new StringBuilder();
        strDate.append(year).append(this.formatMonth(month)).append(this.formatDay(day));
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        dFormat.setLenient(false);
        dFormat.parse(strDate.toString());
        this.year = year;
        this.month = month;
        this.day = day;
        return this;
    }

    public int getNumber() {
        return this.number;
    }

    public DocumentIdSetting setNumber(int number) {
        this.number = number;
        return this;
    }

    public boolean isTenant() {
        return this.tenantEnabled;
    }

    public void disableTenant() {
        this.tenantEnabled = false;
    }

    public DWDao getDao() {
        return this.dao;
    }

    public DocumentIdSetting setDao(DWDao dao) {
        this.dao = dao;
        return this;
    }

    private String formatMonth(int month) throws Exception {
        return String.format("%02d", month);
    }

    private String formatDay(int day) throws Exception {
        return String.format("%02d", day);
    }

    public Map<String, Object> getConditions() {
        return this.conditions;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getPrefix() {
        return this.prefix == null ? "" : this.prefix;
    }

    public DocumentIdSetting setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public int getSerialIdLength() {
        return this.serialIdLength;
    }

    public DocumentIdSetting setSerialIdLength(int serialIdLength) {
        this.serialIdLength = serialIdLength;
        return this;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public String getPattern() {
        return this.pattern;
    }

    public DocumentIdSetting setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public DocumentIdSetting addCondition(Map<String, Object> condition) {
        this.conditions = Optional.ofNullable(this.conditions).orElse(new HashMap());
        this.conditions.putAll(condition);
        return this;
    }

    public DocumentIdSetting addCondition(String columnName, Object columnValue) {
        this.conditions = Optional.ofNullable(this.conditions).orElse(new HashMap());
        this.conditions.put(columnName, columnValue);
        return this;
    }

    public String getSuffix() {
        return Optional.ofNullable(this.suffix).orElse("");
    }

    public DocumentIdSetting setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public String getGroup() throws Exception {
        if (this.group == null) {
            DocumentIdFormatter formatter = new DocumentIdFormatter();
            return formatter.format(this);
        }
        return this.group;
    }
}

