/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.util;

import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.exception.DWSerialLengthOutOfBoundsException;
import com.digiwin.util.DocumentIdFinder;
import com.digiwin.util.DocumentIdFormatter;
import com.digiwin.util.DocumentIdSetting;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DocumentIdGenerator {
    private static final Log logger = LogFactory.getLog(DocumentIdGenerator.class);
    private DocumentIdFormatter formatter = new DocumentIdFormatter();
    private String appId;
    @Autowired
    private DocumentIdFinder finder;
    @Autowired
    private DWRedisService redisTemplate;
    private String redisPrefixFolder = "DAP:DocumentId";

    @Value(value="${appId:}")
    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getId(DocumentIdSetting setting) throws Exception {
        if (setting != null && setting.getNumber() > 1) {
            throw new DWDataException("setting.setNumber can't greater than 1");
        }
        String result = this.generateId(setting).get(0);
        return result;
    }

    public List<String> getIdList(DocumentIdSetting setting) throws Exception {
        List<String> result = this.generateId(setting);
        return result;
    }

    private List<String> generateId(DocumentIdSetting setting) throws Exception {
        if (setting == null) {
            throw new DWDataException("DocumentIdSetting can'n be null ");
        }
        ArrayList<String> result = new ArrayList<String>();
        List<Long> serialIds = this.generateSerialId(setting);
        for (long serialId : serialIds) {
            result.add(this.formatter.format(serialId, setting));
            logger.debug((Object)("serialId:" + serialId));
        }
        return result;
    }

    private List<Long> generateSerialId(DocumentIdSetting setting) throws Exception {
        long startId;
        ArrayList<Long> result = new ArrayList<Long>();
        StringBuilder redisKeyGroup = new StringBuilder();
        redisKeyGroup.append(this.redisPrefixFolder).append(":").append(this.appId).append(":");
        if (setting.isTenant()) {
            Map profile = DWServiceContext.getContext().getProfile();
            redisKeyGroup.append(profile.get(DWTenantUtils.getIAMTenantSidKey())).append(":");
        }
        String group = setting.getGroup();
        if (setting.isAccurateRuleMatchEnable()) {
            redisKeyGroup.append(group).append("{" + setting.getSerialIdLength() + "}").append(setting.getSuffix());
        } else {
            redisKeyGroup.append(group).append(setting.getSuffix());
        }
        if (!this.redisTemplate.hasKey(redisKeyGroup.toString()).booleanValue()) {
            int maxSeriaNo = 0;
            String documentId = this.finder.getMaxSerialNo(group, setting);
            if (documentId != null && !documentId.equals("")) {
                maxSeriaNo = this.formatter.fetchSerialNo(documentId, setting);
            }
            this.redisTemplate.set(redisKeyGroup.toString(), (Object)maxSeriaNo);
        }
        if (setting.isSerialLengthOutOfBoundsExceptionEnable()) {
            Integer maxSeriaNo = Integer.parseInt(this.redisTemplate.get(redisKeyGroup.toString()).toString());
            if ((maxSeriaNo = Integer.valueOf(maxSeriaNo + setting.getNumber())).toString().length() > setting.getSerialIdLength()) {
                throw new DWSerialLengthOutOfBoundsException("serial length was out of bounds");
            }
        }
        long currentId = this.redisTemplate.incrBy(redisKeyGroup.toString(), (long)setting.getNumber());
        for (long i = startId = currentId - (long)setting.getNumber() + 1L; i <= currentId; ++i) {
            result.add(i);
            logger.debug((Object)("Fetch redis serialNo=" + i));
        }
        return result;
    }
}

