/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.util;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.util.DocumentIdSetting;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class DocumentIdFormatter {
    public String format(DocumentIdSetting setting) throws Exception {
        return setting.getPrefix() + this.formatDate(setting);
    }

    @Deprecated
    public String format(String group, long serialId, int serialIdLength) throws Exception {
        StringBuilder result = new StringBuilder();
        String strSerialId = this.formatSerialId(serialIdLength, serialId);
        result.append(group + strSerialId);
        return result.toString();
    }

    protected String format(long serialId, DocumentIdSetting setting) throws Exception {
        String group = setting.getGroup();
        StringBuilder result = new StringBuilder();
        String strSerialId = this.formatSerialId(setting.getSerialIdLength(), serialId);
        result.append(group).append(setting.getSerialPrefix()).append(strSerialId).append(setting.getSuffix());
        return result.toString();
    }

    @Deprecated
    public int fetchSerialNo(String documentId, String group, int serialIdLength) throws Exception {
        String strSerialNo = documentId.substring(group.length());
        Pattern pattern = Pattern.compile("[0-9]*");
        boolean isInteger = pattern.matcher(strSerialNo).matches();
        if (!isInteger) {
            strSerialNo = this.formatSerialId(serialIdLength, 0L);
        }
        return Integer.parseInt(strSerialNo);
    }

    protected int fetchSerialNo(String documentId, DocumentIdSetting setting) throws Exception {
        String strSerialNo = documentId.substring(setting.getGroup().length(), documentId.lastIndexOf(setting.getSuffix()));
        Pattern pattern = Pattern.compile("[0-9]*");
        boolean isInteger = pattern.matcher(strSerialNo).matches();
        if (!isInteger) {
            strSerialNo = this.formatSerialId(setting.getSerialIdLength(), 0L);
        }
        return Integer.parseInt(strSerialNo);
    }

    private String formatMonth(int month) throws Exception {
        return String.format("%02d", month);
    }

    private String formatDay(int day) throws Exception {
        return String.format("%02d", day);
    }

    private String formatSerialId(int serialIdLength, long serialId) throws Exception {
        return String.format("%0" + serialIdLength + "d", serialId);
    }

    private String formatDate(DocumentIdSetting setting) throws Exception {
        Pattern pattern;
        String patternStr = setting.getPattern();
        if (StringUtils.isEmpty((Object)patternStr)) {
            return "";
        }
        StringBuilder strDate = new StringBuilder();
        strDate.append(setting.getYear()).append(this.formatMonth(setting.getMonth())).append(this.formatDay(setting.getDay()));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date date = format.parse(strDate.toString());
        StringBuilder dateStrBuilder = new StringBuilder();
        String year = "";
        String quarterPattern = "";
        String monthPattern = "";
        String weekPattern = "";
        String dayPattern = "";
        String patternLowerCase = patternStr.toLowerCase();
        if (patternLowerCase.indexOf("y") != -1) {
            String yearPattern = patternLowerCase.substring(patternLowerCase.indexOf("y"), patternLowerCase.lastIndexOf("y") + 1);
            pattern = Pattern.compile("[y]{1,4}");
            if (!pattern.matcher(yearPattern).matches()) {
                throw new DWException(String.format("unsupport year pattern like %s", yearPattern));
            }
            format.applyPattern(yearPattern);
            year = format.format(date);
            if (yearPattern.length() == 1 || yearPattern.length() == 3) {
                year = year.substring(4 - yearPattern.length());
            }
        }
        if (patternLowerCase.indexOf("q") != -1) {
            quarterPattern = patternLowerCase.substring(patternLowerCase.indexOf("q"), patternLowerCase.lastIndexOf("q") + 1);
            pattern = Pattern.compile("[q]{1,2}");
            if (!pattern.matcher(quarterPattern).matches()) {
                throw new DWException(String.format("unsupport quarter pattern like %s", quarterPattern));
            }
            String string = quarterPattern = quarterPattern.length() > 1 ? String.format("%02d", this.getQuarter(date)) : String.valueOf(this.getQuarter(date));
        }
        if (patternStr.indexOf("M") != -1) {
            monthPattern = patternStr.substring(patternStr.indexOf("M"), patternStr.lastIndexOf("M") + 1);
            pattern = Pattern.compile("[M]{1,2}");
            if (!pattern.matcher(monthPattern).matches()) {
                throw new DWException(String.format("unsupport month pattern like %s", monthPattern));
            }
            format.applyPattern(monthPattern);
            monthPattern = format.format(date);
        }
        if (patternStr.indexOf("W") != -1) {
            weekPattern = patternStr.substring(patternStr.indexOf("W"), patternStr.lastIndexOf("W") + 1);
            pattern = Pattern.compile("[W]{1,2}");
            if (!pattern.matcher(weekPattern).matches()) {
                throw new DWException(String.format("unsupport week pattern like %s", weekPattern));
            }
            format.applyPattern(weekPattern);
            String string = weekPattern = weekPattern.length() > 1 ? String.format("%02d", this.getWeek(date)) : String.valueOf(this.getWeek(date));
        }
        if (patternStr.indexOf("d") != -1) {
            dayPattern = patternStr.substring(patternStr.indexOf("d"), patternStr.lastIndexOf("d") + 1);
            pattern = Pattern.compile("[d]{1,2}");
            if (!pattern.matcher(dayPattern).matches()) {
                throw new DWException(String.format("unsupport day pattern like %s", dayPattern));
            }
            format.applyPattern(dayPattern);
            dayPattern = format.format(date);
        }
        return dateStrBuilder.append(year).append(quarterPattern).append(monthPattern).append(weekPattern).append(dayPattern).toString();
    }

    private int getQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) / 3 + 1;
    }

    private int getWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        return calendar.get(3);
    }
}

