/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.eai.DWEAICallbackFuse;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.config.DapPropertiesOptionKey;
import com.digiwin.gateway.fuse.config.DapPropertiesOutboundKey;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import com.digiwin.gateway.fuse.exception.DWBrokenCircuitException;
import com.digiwin.gateway.fuse.exception.DWOverLimitException;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

public class DWEAICallback {
    private static Log log = LogFactory.getLog(DWEAICallback.class);
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    private Map<String, Object> parameter;
    private String digiDatakey;
    private String digiSrvcode;
    private String digiReqid;
    private String code;
    private String sqlCode;
    private String description;
    private Map<String, String> customHeader = new HashMap<String, String>();
    private Map<String, String> customCallbackHeader = new HashMap<String, String>();

    public DWEAICallback(String digiSrvcode, String digiReqid, Map<String, Object> parameter) {
        this.digiSrvcode = digiSrvcode;
        this.digiReqid = digiReqid;
        this.parameter = parameter;
    }

    public Map<String, Object> execute() {
        HttpPost httpPost = this.getHttpPost();
        Map<String, Object> result = this.executeHttpRequest(httpPost);
        return result;
    }

    private HttpPost getHttpPost() {
        String value;
        String key;
        String url = DWApplicationConfigUtils.getProperty((String)"eaiUrl");
        HttpPost httpPost = new HttpPost(url + "/CROSS/RESTful/callback");
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        if (!StringUtils.isBlank((CharSequence)this.digiDatakey)) {
            httpPost.addHeader("digi-datakey", this.digiDatakey);
        }
        httpPost.addHeader("digi-srvcode", this.digiSrvcode);
        httpPost.addHeader("digi-reqid", this.digiReqid);
        String digiSrvver = DWApplicationConfigUtils.getProperty((String)"eaiHostVer");
        httpPost.addHeader("digi-srvver", digiSrvver);
        for (Map.Entry<String, String> entry : this.customHeader.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith("digi-")) {
                httpPost.addHeader(key, value);
                continue;
            }
            httpPost.addHeader("digi-" + key, value);
        }
        for (Map.Entry<String, String> entry : this.customCallbackHeader.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.startsWith("digi-callback-")) {
                httpPost.addHeader(key, value);
                continue;
            }
            httpPost.addHeader("digi-callback-" + key, value);
        }
        JSONObject stdDataJo = new JSONObject();
        if ("000".equals(this.digiSrvcode)) {
            JSONObject parameterJo = new JSONObject();
            parameterJo.put("parameter", (Object)new JSONObject(this.parameter));
            stdDataJo.put("std_data", (Object)parameterJo);
        } else {
            JSONObject executionJo = new JSONObject();
            executionJo.put("code", (Object)this.code);
            executionJo.put("sql_code", (Object)this.sqlCode);
            executionJo.put("description", (Object)this.description);
            stdDataJo.put("std_data", (Object)executionJo);
        }
        StringEntity stringEntity = new StringEntity(stdDataJo.toString(), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private Map<String, Object> executeHttpRequest(HttpPost httpPost) {
        OutboundConfig outboundConfig = this.getOutboundConfig();
        CollectorRegistry collectorRegistry = null;
        try {
            ApplicationContext applicationContext = DWApplicationSpringUtils.getContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[DWEAI] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[DWEAI] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        DWEAICallbackFuse eaiCallbackFuse = new DWEAICallbackFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("httpPost", (Object)httpPost);
        DWFuseReturnResponse response = new DWFuseReturnResponse((Object)new JSONObject());
        DWFuseOption option = this.getOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[DWEAI] option: " + option));
        try {
            response = DWFuseExecutor.execute((DWReturnFuse)eaiCallbackFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        }
        catch (DWOverLimitException e) {
            throw new DWRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (DWBrokenCircuitException e) {
            throw new DWRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new DWRuntimeException(e.getMessage(), (Throwable)e);
        }
        JSONObject responseJo = (JSONObject)response.getResponse();
        return responseJo.toMap();
    }

    public void setDigiDatakey(String digiDatakey) {
        this.digiDatakey = digiDatakey;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public void setCustomCallbackHeader(Map<String, String> customCallbackHeader) {
        this.customCallbackHeader = customCallbackHeader;
    }

    public String getDigiDatakey() {
        return this.digiDatakey;
    }

    public Map<String, String> getCustomHeader() {
        return this.customHeader;
    }

    public Map<String, String> getCustomCallbackHeader() {
        return this.customCallbackHeader;
    }

    private DWFuseOption getOption() {
        String isIgnoreUnassignedXRateLimitHeaderKey = DapPropertiesOptionKey.isIgnoreUnassignedXRateLimitHeader();
        String isXRateLimitHeaderOnKey = DapPropertiesOptionKey.isXRateLimitHeaderOn();
        String isCollectMetricsKey = DapPropertiesOptionKey.isCollectMetrics();
        String isAutoFuseHttpStatusCodeKey = DapPropertiesOptionKey.isAutoFuseHttpStatusCode();
        String inboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.inboundErrorHttpStatusCode();
        String outboundErrorHttpStatusCodeKey = DapPropertiesOptionKey.outboundErrorHttpStatusCode();
        String isIgnoreUnassignedXRateLimitHeader = DWApplicationConfigUtils.getProperty((String)isIgnoreUnassignedXRateLimitHeaderKey, (String)String.valueOf(true));
        String isXRateLimitHeaderOn = DWApplicationConfigUtils.getProperty((String)isXRateLimitHeaderOnKey, (String)String.valueOf(true));
        String isCollectMetrics = DWApplicationConfigUtils.getProperty((String)isCollectMetricsKey, (String)String.valueOf(false));
        String isAutoFuseHttpStatusCode = DWApplicationConfigUtils.getProperty((String)isAutoFuseHttpStatusCodeKey, (String)String.valueOf(true));
        String inboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)inboundErrorHttpStatusCodeKey, (String)String.valueOf(429));
        String outboundErrorHttpStatusCode = DWApplicationConfigUtils.getProperty((String)outboundErrorHttpStatusCodeKey, (String)String.valueOf(503));
        DWFuseOption option = new DWFuseOption();
        option.setIgnoreUnassignedXRateLimitHeader(isIgnoreUnassignedXRateLimitHeader);
        option.setXRateLimitHeaderOn(isXRateLimitHeaderOn);
        option.setCollectMetrics(isCollectMetrics);
        option.setAutoFuseHttpStatusCode(isAutoFuseHttpStatusCode);
        option.setInboundErrorHttpStatusCode(inboundErrorHttpStatusCode);
        option.setOutboundErrorHttpStatusCode(outboundErrorHttpStatusCode);
        return option;
    }

    private OutboundConfig getOutboundConfig() {
        String key = "eai";
        String enableKey = DapPropertiesOutboundKey.enable((String)key);
        String failureRateKey = DapPropertiesOutboundKey.failureRate((String)key);
        String openSecKey = DapPropertiesOutboundKey.openSec((String)key);
        String halfOpenCalculateSizeKey = DapPropertiesOutboundKey.halfOpenCalculateSize((String)key);
        String closeCalculateSizeKey = DapPropertiesOutboundKey.closeCalculateSize((String)key);
        String enable = DWApplicationConfigUtils.getProperty((String)enableKey, (String)"false");
        String failureRate = DWApplicationConfigUtils.getProperty((String)failureRateKey, (String)String.valueOf(50));
        String openSec = DWApplicationConfigUtils.getProperty((String)openSecKey, (String)String.valueOf(60));
        String halfOpenCalculateSize = DWApplicationConfigUtils.getProperty((String)halfOpenCalculateSizeKey, (String)String.valueOf(10));
        String closeCalculateSize = DWApplicationConfigUtils.getProperty((String)closeCalculateSizeKey, (String)String.valueOf(100));
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        return outboundConfig;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSqlCode() {
        return this.sqlCode;
    }

    public void setSqlCode(String sqlCode) {
        this.sqlCode = sqlCode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

