/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.log.service;

import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.digiwin.app.log.DapLogHttpClientFactory;
import com.digiwin.app.log.JsonUtil;
import com.digiwin.app.log.dto.DapLogDto;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class DapLogService {
    private static Log log = LogFactory.getLog(DapLogService.class);
    private static ExecutorService executorService = new ThreadPoolExecutor(10, 30, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), new ThreadPoolExecutor.DiscardPolicy());
    private static CloseableHttpClient httpClient = DapLogHttpClientFactory.createHttpClient();

    public static void savleLog(DapLogDto dapLogDto) {
        if (StringUtils.isBlank((String)dapLogDto.getLogUrl())) {
            return;
        }
        executorService.submit(() -> {
            DapLogDto[] logArray = new DapLogDto[]{dapLogDto};
            HttpPost httpPost = new HttpPost(dapLogDto.getLogUrl());
            StringEntity stringEntity = new StringEntity(JsonUtil.toString(logArray), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
            try {
                httpClient.execute((HttpUriRequest)httpPost);
            }
            catch (Exception e) {
                log.error((Object)"send log error {}", (Throwable)e);
            }
        });
    }
}

