/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import com.digiwin.app.eai.DWEAIFuseProperties;
import com.digiwin.http.context.DWLoadBalanceUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class DWEAIHttpClient
extends CloseableHttpClient {
    private static Log log = LogFactory.getLog(DWEAIHttpClient.class);
    private String name;
    private CloseableHttpClient primaryHttpClient;
    private CloseableHttpClient retryHttpClient;
    private DWEAIHttpRequestRetryHandler outerRetryHandler = new DWEAIHttpRequestRetryHandler();

    public static CloseableHttpClient create(String name, HttpRoutePlanner httpRoutePlanner) {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(500);
        manager.setDefaultMaxPerRoute(500);
        DWEAIDefaultHttpRequestRetryHandler eaiRetryHandler = new DWEAIDefaultHttpRequestRetryHandler();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).setRetryHandler((HttpRequestRetryHandler)eaiRetryHandler).setRoutePlanner(httpRoutePlanner).build();
        IdleConnectionMonitorThread monitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)manager);
        monitor.start();
        CloseableHttpClient retryHttpClient = HttpClients.custom().setConnectionReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy()).setRetryHandler((HttpRequestRetryHandler)eaiRetryHandler).setRoutePlanner(httpRoutePlanner).build();
        return new DWEAIHttpClient(name, httpClient, retryHttpClient);
    }

    private DWEAIHttpClient(String name, CloseableHttpClient primaryHttpClient, CloseableHttpClient retryHttpClient) {
        if (name == null) {
            name = "Unknown-DWEAIHttpClient";
        }
        this.name = name;
        this.primaryHttpClient = primaryHttpClient;
        this.retryHttpClient = retryHttpClient;
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Integer execCount = 1;
        while (true) {
            try {
                if (execCount == 1) {
                    return this.primaryHttpClient.doExecute(target, request, context);
                }
                if (context != null) {
                    DWLoadBalanceUtils.restoreSetting((HttpContext)context);
                }
                log.warn((Object)(this.name + " - retryHttpClient ready to execute..."));
                return this.retryHttpClient.execute(target, request, context);
            }
            catch (IOException ex) {
                if (this.outerRetryHandler.retryRequest(ex, execCount, context)) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)(this.name + " - I/O exception (" + ex.getClass().getName() + ") caught when processing request to " + target.toString() + ": " + ex.getMessage()));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.name + " - " + ex.getMessage()), (Throwable)ex);
                    }
                } else {
                    throw ex;
                }
                Integer n = execCount;
                execCount = execCount + 1;
                continue;
            }
            break;
        }
    }

    private boolean canRetry(Integer executionCount) {
        int maxRetries = 3;
        Integer n = executionCount;
        executionCount = executionCount + 1;
        log.warn((Object)("Retry attempt: " + executionCount));
        if (executionCount > maxRetries) {
            log.warn((Object)"Maximum retries reached. Exiting.");
            return false;
        }
        long backOff = 2000L * (long)executionCount.intValue();
        log.warn((Object)("backoff: " + backOff));
        try {
            Thread.sleep(backOff);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void close() throws IOException {
        this.primaryHttpClient.close();
    }

    public HttpParams getParams() {
        return this.primaryHttpClient.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.primaryHttpClient.getConnectionManager();
    }

    private static class DWEAIDefaultHttpRequestRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private DWEAIDefaultHttpRequestRetryHandler() {
            super(3, false, Arrays.asList(InterruptedIOException.class, ConnectException.class, SSLException.class, NoHttpResponseException.class));
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager manager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.manager.closeExpiredConnections();
                        long maxIdleTime = DWEAIFuseProperties.getHttpClientConnectionMaxIdleTime();
                        this.manager.closeIdleConnections(maxIdleTime, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                log.warn((Object)"Interrupted!", (Throwable)ex);
                Thread.currentThread().interrupt();
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    private class DWEAIHttpRequestRetryHandler
    implements HttpRequestRetryHandler {
        private int maxRetries = 3;

        private DWEAIHttpRequestRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            boolean retry = false;
            String errorMessage = exception.getMessage();
            if (errorMessage == null) {
                errorMessage = "null";
            }
            if (exception instanceof SocketException && errorMessage.toLowerCase().contains("connection reset") || exception instanceof NoHttpResponseException) {
                retry = true;
                log.warn((Object)(DWEAIHttpClient.this.name + " - Retry attempt: " + executionCount));
                if (executionCount > this.maxRetries) {
                    log.warn((Object)("Maximum retries" + this.maxRetries + " reached. Exiting."));
                    retry = false;
                } else {
                    long backOff = 2000L * (long)executionCount;
                    log.warn((Object)(DWEAIHttpClient.this.name + " - backoff: " + backOff));
                    try {
                        Thread.sleep(backOff);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return retry;
        }
    }
}

