/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai;

import com.digiwin.app.eai.DWEAIFuseProperties;
import com.digiwin.app.eai.util.LmcUtil;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.exception.DWServerErrorException;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.http.context.DWLoadBalanceUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DWEAIHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.json.JSONObject;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class DWEAICallbackFuse
implements DWReturnFuse<JSONObject> {
    private static Log log = LogFactory.getLog(DWEAICallbackFuse.class);
    private static CloseableHttpClient httpClient;

    public JSONObject execute(DWFuseParameter fuseParameter) throws Exception {
        HttpPost httpPost = (HttpPost)fuseParameter.get("httpPost");
        HttpContext httpContext = (HttpContext)fuseParameter.get("httpContext");
        Map requestHeader = (Map)fuseParameter.get("requestHeader");
        Map body = (Map)fuseParameter.get("body");
        boolean isLmcLog = (Boolean)fuseParameter.get("isLmcLog");
        long callbackTimestamp = Calendar.getInstance().getTimeInMillis();
        Header[] callbackHeader = httpPost.getAllHeaders();
        JSONObject responseJo = new JSONObject();
        String result = "";
        int statusCode = -1;
        if (isLmcLog) {
            LmcUtil.callbackEvent(callbackHeader, body, requestHeader, callbackTimestamp);
        }
        CloseableHttpResponse response = null;
        try {
            int maxRetries = 3;
            int currentRetry = 0;
            while (currentRetry < maxRetries) {
                try {
                    if (httpContext != null) {
                        DWLoadBalanceUtils.restoreSetting((HttpContext)httpContext);
                    }
                    response = httpClient.execute((HttpUriRequest)httpPost, httpContext);
                    break;
                }
                catch (SocketException e) {
                    if (e.getMessage().toLowerCase().contains("connection reset")) {
                        log.warn((Object)("Connection reset occurred: " + e.getMessage()));
                        log.warn((Object)("Retry attempt: " + ++currentRetry));
                        if (currentRetry == maxRetries) {
                            log.warn((Object)"Maximum retries reached. Exiting.");
                            throw e;
                        }
                        long backoff = 2000L * (long)currentRetry;
                        log.warn((Object)("backoff: " + backoff));
                        try {
                            Thread.sleep(backoff);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    log.warn((Object)("Other SocketException occurred: " + e.getMessage()));
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
            }
            JSONObject headerJo = new JSONObject();
            Header[] callbackRtnHeader = response.getAllHeaders();
            List<Header> headers = Arrays.asList(callbackRtnHeader);
            for (Header header : headers) {
                if (!header.getName().startsWith("digi-")) continue;
                if ("digi-message".equalsIgnoreCase(header.getName())) {
                    headerJo.put(header.getName(), (Object)new String(Base64.getDecoder().decode(header.getValue()), StandardCharsets.UTF_8));
                    continue;
                }
                headerJo.put(header.getName(), (Object)header.getValue());
            }
            responseJo.put("headers", (Object)headerJo);
            InputStream content = response.getEntity().getContent();
            if (content == null) {
                Header header;
                responseJo.put("messageBody", (Object)"");
                header = responseJo;
                return header;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(content, StandardCharsets.UTF_8);
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                StringBuffer stringBuffer = new StringBuffer("");
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                result = stringBuffer.toString();
                responseJo.put("messageBody", (Object)result);
            }
            statusCode = response.getStatusLine().getStatusCode();
            responseJo.put("eai-response-http-status", statusCode);
            long callbackRtnTimestamp = Calendar.getInstance().getTimeInMillis();
            if (isLmcLog) {
                if (statusCode == 200) {
                    LmcUtil.callbackRtnEvent(callbackRtnHeader, result, requestHeader, callbackRtnTimestamp);
                } else {
                    LmcUtil.callbackRtnEventOnNot200(callbackRtnHeader, result, requestHeader, callbackRtnTimestamp, statusCode);
                }
            }
        }
        catch (Exception e) {
            if (isLmcLog) {
                LmcUtil.callbackRtnEventOnException(e, requestHeader, callbackTimestamp);
            }
            throw e;
        }
        finally {
            try {
                response.close();
            }
            catch (Exception exception) {}
        }
        if (statusCode == 429 || statusCode == 502 || statusCode == 503 || statusCode == 504 || statusCode == 413) {
            log.warn((Object)("[DWEAICallbackFuse] HTTP uri:" + httpPost.getURI().toString() + ", status Code: " + statusCode + ", result: " + result));
            throw new DWServerErrorException(statusCode, result);
        }
        return responseJo;
    }

    static {
        ApplicationContext applicationContext = SpringContextUtils.getContext();
        HttpRoutePlanner dwReReouteRoutePlanner = null;
        Object dwDefaultMainExecWrapperFactory = null;
        try {
            dwReReouteRoutePlanner = (HttpRoutePlanner)applicationContext.getBean("dwDefaultReRoutePlanner", HttpRoutePlanner.class);
            dwDefaultMainExecWrapperFactory = applicationContext.getBean("dwDefaultMainExecWrapperFactory");
        }
        catch (BeansException e) {
            log.error((Object)"get dwDefaultHttpLoadbalanceRoute fail ", (Throwable)e);
        }
        String dwLegacyEaiHttpClientEnabled = System.getenv().get("dwLegacyEaiHttpClientEnabled");
        if (Boolean.parseBoolean(dwLegacyEaiHttpClientEnabled)) {
            PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
            manager.setMaxTotal(500);
            manager.setDefaultMaxPerRoute(500);
            httpClient = null != dwReReouteRoutePlanner && null != dwDefaultMainExecWrapperFactory ? DWEAIHttpClient.getHttpClientBuid(dwReReouteRoutePlanner, dwDefaultMainExecWrapperFactory).setConnectionManager((HttpClientConnectionManager)manager).build() : HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
            IdleConnectionMonitorThread monitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)manager);
            monitor.start();
        } else {
            httpClient = DWEAIHttpClient.create("DWEAICallbackFuse", dwReReouteRoutePlanner, dwDefaultMainExecWrapperFactory);
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager manager;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.manager.closeExpiredConnections();
                        long maxIdleTime = DWEAIFuseProperties.getHttpClientConnectionMaxIdleTime();
                        this.manager.closeIdleConnections(maxIdleTime, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                log.warn((Object)"Interrupted!", (Throwable)ex);
                Thread.currentThread().interrupt();
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

