/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai.fasynctask.compensation;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.fasynctask.FasyncTaskService;
import com.digiwin.app.eai.fasynctask.FasyncTaskVo;
import com.digiwin.app.eai.serviceinstance.ServiceInstanceService;
import com.digiwin.app.eai.serviceinstance.ServiceInstanceVo;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;

public class CompensationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompensationService.class);
    private String appId;
    private Environment environment;
    private int serviceInstanceCheckFrequency;
    private int serviceInstanceOfflineTimeout;
    private String fasyncTaskCompensationUrl;
    private int fasyncTaskCompensationKeyTimeout;
    private ServiceInstanceService dwEaiServiceInstanceService;
    private FasyncTaskService dwEaiFasyncTaskService;
    private DWEAIProperties dwEaiProperties;
    private DWHttpClient httpClient;
    private RedissonClient redisson;
    private RedisTemplate<String, Object> redis;

    public CompensationService(Environment environment, ServiceInstanceService dwEaiServiceInstanceService, FasyncTaskService dwEaiFasyncTaskService, DWEAIProperties dwEaiProperties, DWHttpClient httpClient, RedissonClient redisson) {
        this.serviceInstanceCheckFrequency = Integer.parseInt(environment.getProperty("dap.eai.service-instance.check.frequency", "180000"));
        this.serviceInstanceOfflineTimeout = Integer.parseInt(environment.getProperty("dap.eai.service-instance.offline.timeout", "180000"));
        this.fasyncTaskCompensationUrl = environment.getProperty("dap.eai.fasync-task.compensation.url");
        this.dwEaiServiceInstanceService = dwEaiServiceInstanceService;
        this.dwEaiFasyncTaskService = dwEaiFasyncTaskService;
        this.dwEaiProperties = dwEaiProperties;
        this.httpClient = httpClient;
        this.fasyncTaskCompensationKeyTimeout = Integer.parseInt(environment.getProperty("dap.eai.fasync-task.compensation.key.timeout", "3000"));
        this.redisson = redisson;
    }

    public void startUp() {
        CompensationThread serviceInstanceThread = new CompensationThread(this, "dap-eai-fasynctask-compensation");
        serviceInstanceThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compensate() {
        LOGGER.debug("Compensation service compensate...");
        List<ServiceInstanceVo> serviceInstanceVos = this.dwEaiServiceInstanceService.getServiceInstances();
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.add(14, -this.serviceInstanceOfflineTimeout);
        Date now = nowCalendar.getTime();
        LOGGER.debug("now calendar=" + String.valueOf(now));
        for (ServiceInstanceVo serviceInstanceVo : serviceInstanceVos) {
            Date serviceInstanceCheckTime = serviceInstanceVo.getCheckTime();
            if (serviceInstanceCheckTime.before(now)) {
                String lockKey = "eai:fasync:compensation:" + serviceInstanceVo.getAppId() + ":" + serviceInstanceVo.getGroupName();
                RLock distributeLock = this.getLock(lockKey);
                if (distributeLock == null) continue;
                try {
                    String instanceName = serviceInstanceVo.getInstanceName();
                    LOGGER.debug("service instance check time=" + String.valueOf(serviceInstanceCheckTime));
                    LOGGER.debug("before now=" + String.valueOf(now));
                    List<FasyncTaskVo> fasyncTaskVos = this.dwEaiFasyncTaskService.getWaitingFasyncTasks(instanceName);
                    String restfulServicePath = this.dwEaiProperties.getRestfulServicePath();
                    LOGGER.debug("restful service path=" + restfulServicePath);
                    LOGGER.debug("compensation url=" + this.fasyncTaskCompensationUrl);
                    for (FasyncTaskVo fasyncTaskVo : fasyncTaskVos) {
                        LOGGER.debug("request header=" + String.valueOf(fasyncTaskVo.getRequestHeader()));
                        LOGGER.debug("request body=" + fasyncTaskVo.getRequestBody());
                        try {
                            URIBuilder uriBuilder = new URIBuilder(this.fasyncTaskCompensationUrl + "/" + restfulServicePath);
                            HttpPost post = new HttpPost(uriBuilder.build());
                            Map requestBodyMap = (Map)DWGsonProvider.getGson().fromJson(fasyncTaskVo.getRequestBody(), Map.class);
                            post.setEntity((HttpEntity)new DWJsonEntity((Object)requestBodyMap));
                            fasyncTaskVo.getRequestHeader().entrySet().forEach(entry -> {
                                if (!((String)entry.getKey()).equalsIgnoreCase("content-length")) {
                                    post.addHeader((String)entry.getKey(), (String)entry.getValue());
                                }
                            });
                            post.addHeader("digi-async-supply", "true");
                            HttpResponse response = this.httpClient.execute((HttpUriRequest)post, new DWRequestOption(true));
                            String reponseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                            LOGGER.debug("response body=" + reponseBody);
                        }
                        catch (Exception e) {
                            LOGGER.error("compensate method exception", (Throwable)e);
                        }
                    }
                    this.dwEaiServiceInstanceService.deleteServiceInstance(serviceInstanceVo.getAppId(), instanceName);
                }
                finally {
                    this.unlock(distributeLock);
                }
            } else {
                LOGGER.debug("service instance check time=" + String.valueOf(serviceInstanceCheckTime));
                LOGGER.debug("after now=" + String.valueOf(now));
            }
            LOGGER.debug(serviceInstanceVo.getAppId());
            LOGGER.debug(serviceInstanceVo.getInstanceName());
            LOGGER.debug(serviceInstanceVo.getGroupName());
            LOGGER.debug(serviceInstanceVo.getCheckTime().toString());
        }
    }

    private RLock getLock(String lockId) {
        RLock lock = null;
        try {
            lock = this.redisson.getLock(lockId);
            boolean tryLock = lock.tryLock((long)this.fasyncTaskCompensationKeyTimeout, TimeUnit.MILLISECONDS);
            if (!tryLock) {
                lock = null;
            }
            LOGGER.debug("get lock, lock id=" + lockId);
        }
        catch (RedisException e) {
            LOGGER.error("compensation service lock failure", (Throwable)e);
            lock = null;
        }
        catch (InterruptedException e) {
            LOGGER.error("compensation service lock failure", (Throwable)e);
            lock = null;
        }
        return lock;
    }

    private void unlock(RLock lock) {
        try {
            if (lock != null) {
                lock.unlock();
                LOGGER.debug("unlock, lock id=" + lock.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("compensation service unlock failure\uff1a[" + lock.getName() + "]", (Throwable)e);
        }
    }

    private class CompensationThread
    extends Thread {
        CompensationService compensationService;

        public CompensationThread(CompensationService compensationService2, String threadName) {
            super(threadName);
            this.compensationService = compensationService2;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(CompensationService.this.serviceInstanceCheckFrequency);
                        this.compensationService.compensate();
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error("CompensationService compensate exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

