/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse;

import com.digiwin.gateway.fuse.DWCircuitBreaker;
import com.digiwin.gateway.fuse.DWRateLimiter;
import com.digiwin.gateway.fuse.Registry;
import com.digiwin.gateway.fuse.config.InboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.exception.DWFuseBusinessException;
import com.digiwin.gateway.fuse.execute.DecoratorWrapper;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.prometheus.client.CollectorRegistry;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWFuseDecorator {
    private static Log log = LogFactory.getLog(DWFuseDecorator.class);

    public static DecoratorWrapper get(Runnable runnable, InboundConfig inboundConfig) {
        DWRateLimiter dwRateLimiter = DWFuseDecorator.getDWRateLimiter(inboundConfig);
        if (!dwRateLimiter.isEnable()) {
            DecoratorWrapper decoratorWrapper = new DecoratorWrapper(runnable, dwRateLimiter);
            return decoratorWrapper;
        }
        RateLimiter rateLimiter = dwRateLimiter.getRateLimiter();
        Runnable decorateRunnable = RateLimiter.decorateRunnable((RateLimiter)rateLimiter, (Runnable)runnable);
        DecoratorWrapper decoratorWrapper = new DecoratorWrapper(decorateRunnable, dwRateLimiter);
        return decoratorWrapper;
    }

    public static DecoratorWrapper get(Runnable runnable, OutboundConfig outboundConfig) {
        DWCircuitBreaker dwCircuitBreaker = DWFuseDecorator.getDWCircuitBreaker(outboundConfig);
        if (!dwCircuitBreaker.isEnable()) {
            DecoratorWrapper decoratorWrapper = new DecoratorWrapper(runnable, dwCircuitBreaker);
            return decoratorWrapper;
        }
        CircuitBreaker circuitBreaker = dwCircuitBreaker.getCircuitBreaker();
        Runnable decorateRunnable = CircuitBreaker.decorateRunnable((CircuitBreaker)circuitBreaker, (Runnable)runnable);
        DecoratorWrapper decoratorWrapper = new DecoratorWrapper(decorateRunnable, dwCircuitBreaker);
        return decoratorWrapper;
    }

    public static DecoratorWrapper get(Runnable runnable, InboundConfig inboundConfig, OutboundConfig outboundConfig) {
        DecoratorWrapper circuitBreakerDecoratorWrapper = DWFuseDecorator.get(runnable, outboundConfig);
        Runnable circuitBreakerDecorateRunnable = circuitBreakerDecoratorWrapper.getRunnable();
        DecoratorWrapper rateLimiterDecoratorWrapper = DWFuseDecorator.get(circuitBreakerDecorateRunnable, inboundConfig);
        Runnable decorateRunnable = rateLimiterDecoratorWrapper.getRunnable();
        DWRateLimiter dwRateLimiter = rateLimiterDecoratorWrapper.getDWRateLimiter();
        DWCircuitBreaker dwCircuitBreaker = circuitBreakerDecoratorWrapper.getDWCircuitBreaker();
        DecoratorWrapper decoratorWrapper = new DecoratorWrapper(decorateRunnable, dwRateLimiter, dwCircuitBreaker);
        return decoratorWrapper;
    }

    private static DWRateLimiter getDWRateLimiter(InboundConfig inboundConfig) {
        CollectorRegistry collectorRegistry = inboundConfig.getCollectorRegistry();
        String key = inboundConfig.getKey();
        int maxWaitSec = inboundConfig.getMaxWaitSec();
        int limit = inboundConfig.getLimit();
        long resetNanoSec = inboundConfig.getResetNanoSec();
        RateLimiterRegistry rateLimiterRegistry = null;
        rateLimiterRegistry = collectorRegistry == null ? Registry.getRateLimiterRegistry() : Registry.getRateLimiterRegistry(collectorRegistry);
        RateLimiterConfig.Builder builder = RateLimiterConfig.custom().limitRefreshPeriod(Duration.ofNanos(resetNanoSec)).limitForPeriod(limit).timeoutDuration(Duration.ofSeconds(maxWaitSec));
        RateLimiter rateLimiter = rateLimiterRegistry.rateLimiter(key, builder.build());
        DWRateLimiter dwRateLimiter = new DWRateLimiter(rateLimiter, inboundConfig.isEnable());
        log.debug((Object)("[InboundConfig] " + inboundConfig));
        return dwRateLimiter;
    }

    private static DWCircuitBreaker getDWCircuitBreaker(OutboundConfig outboundConfig) {
        CollectorRegistry collectorRegistry = outboundConfig.getCollectorRegistry();
        String key = outboundConfig.getKey();
        int failureRate = outboundConfig.getFailureRate();
        int openSec = outboundConfig.getOpenSec();
        int halfOpenCalculateSize = outboundConfig.getHalfOpenCalculateSize();
        int closeCalculateSize = outboundConfig.getCloseCalculateSize();
        CircuitBreakerRegistry circuitBreakerRegistry = null;
        circuitBreakerRegistry = collectorRegistry == null ? Registry.getCircuitBreakerRegistry() : Registry.getCircuitBreakerRegistry(collectorRegistry);
        CircuitBreakerConfig.Builder builder = CircuitBreakerConfig.custom().failureRateThreshold((float)failureRate).waitDurationInOpenState(Duration.ofSeconds(openSec)).permittedNumberOfCallsInHalfOpenState(halfOpenCalculateSize).slidingWindow(closeCalculateSize, closeCalculateSize, CircuitBreakerConfig.SlidingWindowType.COUNT_BASED).ignoreExceptions(new Class[]{DWFuseBusinessException.class});
        CircuitBreaker circuitBreaker = circuitBreakerRegistry.circuitBreaker(key, builder.build());
        DWCircuitBreaker dwCircuitBreaker = new DWCircuitBreaker(circuitBreaker, outboundConfig.isEnable());
        log.debug((Object)("[OutboundConfig] " + outboundConfig));
        return dwCircuitBreaker;
    }
}

