/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.registry;

import com.digiwin.gateway.fuse.registry.DWCircuitBreakerRegistry;
import com.digiwin.gateway.fuse.registry.DWRateLimiterRegistry;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.prometheus.collectors.CircuitBreakerMetricsCollector;
import io.github.resilience4j.prometheus.collectors.RateLimiterMetricsCollector;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Registry {
    private static Log log = LogFactory.getLog(Registry.class);
    private static CircuitBreakerRegistry circuitBreakerRegistry = new DWCircuitBreakerRegistry(CircuitBreakerConfig.ofDefaults());
    private static RateLimiterRegistry rateLimiterRegistry = new DWRateLimiterRegistry(RateLimiterConfig.ofDefaults());

    public static CircuitBreakerRegistry getCircuitBreakerRegistry() {
        return circuitBreakerRegistry;
    }

    public static RateLimiterRegistry getRateLimiterRegistry() {
        return rateLimiterRegistry;
    }

    public static CircuitBreakerRegistry getCircuitBreakerRegistry(CollectorRegistry collectorRegistry) {
        try {
            collectorRegistry.register((Collector)CircuitBreakerMetricsCollector.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry));
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[Registry] " + e.getMessage()));
            log.debug((Object)("[Registry] " + stackTrace));
        }
        return circuitBreakerRegistry;
    }

    public static RateLimiterRegistry getRateLimiterRegistry(CollectorRegistry collectorRegistry) {
        try {
            collectorRegistry.register((Collector)RateLimiterMetricsCollector.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry));
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[Registry] " + e.getMessage()));
            log.debug((Object)("[Registry] " + stackTrace));
        }
        return rateLimiterRegistry;
    }
}

