/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.registry;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class DWCircuitBreakerRegistry
extends AbstractRegistry<CircuitBreaker, CircuitBreakerConfig>
implements CircuitBreakerRegistry {
    public DWCircuitBreakerRegistry() {
        this(CircuitBreakerConfig.ofDefaults());
    }

    public DWCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public DWCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public DWCircuitBreakerRegistry(Map<String, CircuitBreakerConfig> configs, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        this(configs.getOrDefault("default", CircuitBreakerConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public DWCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public DWCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public DWCircuitBreakerRegistry(CircuitBreakerConfig defaultConfig, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    public Seq<CircuitBreaker> getAllCircuitBreakers() {
        return Array.ofAll(this.entryMap.values());
    }

    public CircuitBreaker circuitBreaker(String name) {
        return this.circuitBreaker(name, (CircuitBreakerConfig)this.getDefaultConfig());
    }

    public CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig config) {
        Supplier<CircuitBreaker> supplier = () -> CircuitBreaker.of((String)name, (CircuitBreakerConfig)Objects.requireNonNull(config, "Config must not be null"));
        return this.circuitBreaker(name, config, supplier);
    }

    public CircuitBreaker circuitBreaker(String name, String configName) {
        Optional optional = this.getConfiguration(configName);
        if (!optional.isPresent()) {
            throw new NoSuchElementException();
        }
        CircuitBreakerConfig config = (CircuitBreakerConfig)optional.get();
        Supplier<CircuitBreaker> supplier = () -> CircuitBreaker.of((String)name, (CircuitBreakerConfig)((CircuitBreakerConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
        return this.circuitBreaker(name, config, supplier);
    }

    public CircuitBreaker circuitBreaker(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfigSupplier) {
        CircuitBreakerConfig config = circuitBreakerConfigSupplier.get();
        Supplier<CircuitBreaker> supplier = () -> CircuitBreaker.of((String)name, (CircuitBreakerConfig)((CircuitBreakerConfig)Objects.requireNonNull(Objects.requireNonNull(circuitBreakerConfigSupplier, "Supplier must not be null").get(), "Config must not be null")));
        return this.circuitBreaker(name, config, supplier);
    }

    private CircuitBreaker circuitBreaker(String name, CircuitBreakerConfig config, Supplier<CircuitBreaker> supplier) {
        Optional findEntry = this.find(name);
        if (findEntry.isPresent()) {
            CircuitBreaker findCircuitBreaker = (CircuitBreaker)findEntry.get();
            CircuitBreakerConfig findCircuitBreakerConfig = findCircuitBreaker.getCircuitBreakerConfig();
            if (this.isConfigEqual(config, findCircuitBreakerConfig)) {
                return (CircuitBreaker)this.computeIfAbsent(name, supplier);
            }
            this.remove(name);
            return (CircuitBreaker)this.computeIfAbsent(name, supplier);
        }
        return (CircuitBreaker)this.computeIfAbsent(name, supplier);
    }

    private boolean isConfigEqual(CircuitBreakerConfig config1, CircuitBreakerConfig config2) {
        float failureRate1 = config1.getFailureRateThreshold();
        Duration openSec1 = config1.getWaitDurationInOpenState();
        int halfOpenCalculateSize1 = config1.getPermittedNumberOfCallsInHalfOpenState();
        int closeCalculateSize1 = config1.getSlidingWindowSize();
        float failureRate2 = config2.getFailureRateThreshold();
        Duration openSec2 = config2.getWaitDurationInOpenState();
        int halfOpenCalculateSize2 = config2.getPermittedNumberOfCallsInHalfOpenState();
        int closeCalculateSize2 = config2.getSlidingWindowSize();
        return failureRate1 == failureRate2 && openSec1.equals(openSec2) && halfOpenCalculateSize1 == halfOpenCalculateSize2 && closeCalculateSize1 == closeCalculateSize2;
    }
}

