/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.spring;

import com.digiwin.gateway.fuse.spring.FuseExceptionHandler;
import com.digiwin.gateway.fuse.spring.FuseInboundAspect;
import com.digiwin.gateway.fuse.spring.FuseOutboundAspect;
import com.digiwin.gateway.fuse.spring.pojo.FuseConfig;
import java.io.InputStream;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.yaml.snakeyaml.Yaml;

@Configuration
public class FuseAspectConfiguration {
    @Bean
    public FuseConfig fuseConfig() {
        FuseConfig fuseConfig = null;
        try {
            ClassPathResource resource = new ClassPathResource("fuse.yml");
            InputStream inputStream = resource.getInputStream();
            fuseConfig = (FuseConfig)new Yaml().loadAs(inputStream, FuseConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fuseConfig == null) {
            fuseConfig = new FuseConfig();
        }
        return fuseConfig;
    }

    @Bean
    public FuseInboundAspect fuseInboundAspect() {
        FuseInboundAspect fuseInboundAspect = new FuseInboundAspect();
        return fuseInboundAspect;
    }

    @Bean
    public FuseOutboundAspect fuseOutboundAspect() {
        FuseOutboundAspect fuseOutboundAspect = new FuseOutboundAspect();
        return fuseOutboundAspect;
    }

    @Bean
    public FuseExceptionHandler fuseExceptionHandler(FuseConfig fuseConfig) {
        boolean isAutoFuseHttpStatusCode = fuseConfig.isAutoFuseHttpStatusCode();
        if (!isAutoFuseHttpStatusCode) {
            return null;
        }
        FuseExceptionHandler fuseExceptionHandler = new FuseExceptionHandler();
        return fuseExceptionHandler;
    }
}

