/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.fuse.spring;

import com.digiwin.gateway.fuse.annotation.FuseInbound;
import com.digiwin.gateway.fuse.annotation.FuseOutbound;
import com.digiwin.gateway.fuse.config.InboundConfig;
import com.digiwin.gateway.fuse.config.InboundConfigBuilder;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.config.OutboundConfigBuilder;
import com.digiwin.gateway.fuse.spring.pojo.Fuse;
import com.digiwin.gateway.fuse.spring.pojo.FuseConfig;
import com.digiwin.gateway.fuse.spring.pojo.Inbound;
import com.digiwin.gateway.fuse.spring.pojo.Outbound;
import java.util.Map;

public class ConfigDecider {
    public static InboundConfig get(FuseConfig fuseConfig, FuseInbound fuseInbound) {
        String key = fuseInbound.key();
        boolean enable = fuseInbound.enable();
        int maxWaitSec = fuseInbound.maxWaitSec();
        int limit = fuseInbound.limit();
        long resetNanoSec = fuseInbound.resetNanoSec();
        InboundConfig inboundConfig = new InboundConfigBuilder(key).enable(enable).maxWaitSec(maxWaitSec).limit(limit).resetNanoSec(resetNanoSec).build();
        Map<String, Fuse> map = fuseConfig.getFuse();
        if (!map.containsKey(key)) {
            return inboundConfig;
        }
        Fuse fuse = map.get(key);
        Inbound inbound = fuse.getInbound();
        if (inbound == null) {
            return inboundConfig;
        }
        inboundConfig.setEnable(inbound.isEnable(enable));
        inboundConfig.setMaxWaitSec(inbound.getMaxWaitSec(maxWaitSec));
        inboundConfig.setLimit(inbound.getLimit(limit));
        inboundConfig.setResetNanoSec(inbound.getResetNanoSec(resetNanoSec));
        return inboundConfig;
    }

    public static OutboundConfig get(FuseConfig fuseConfig, FuseOutbound fuseOutbound) {
        String key = fuseOutbound.key();
        boolean enable = fuseOutbound.enable();
        int failureRate = fuseOutbound.failureRate();
        int openSec = fuseOutbound.openSec();
        int halfOpenCalculateSize = fuseOutbound.halfOpenCalculateSize();
        int closeCalculateSize = fuseOutbound.closeCalculateSize();
        OutboundConfig outboundConfig = new OutboundConfigBuilder(key).enable(enable).failureRate(failureRate).openSec(openSec).halfOpenCalculateSize(halfOpenCalculateSize).closeCalculateSize(closeCalculateSize).build();
        Map<String, Fuse> map = fuseConfig.getFuse();
        if (!map.containsKey(key)) {
            return outboundConfig;
        }
        Fuse fuse = map.get(key);
        Outbound outbound = fuse.getOutbound();
        if (outbound == null) {
            return outboundConfig;
        }
        outboundConfig.setEnable(outbound.isEnable(enable));
        outboundConfig.setFailureRate(outbound.getFailureRate(failureRate));
        outboundConfig.setOpenSec(outbound.getOpenSec(openSec));
        outboundConfig.setHalfOpenCalculateSize(outbound.getHalfOpenCalculateSize(halfOpenCalculateSize));
        outboundConfig.setCloseCalculateSize(outbound.getCloseCalculateSize(closeCalculateSize));
        return outboundConfig;
    }
}

