/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.context;

import com.digiwin.http.client.DWHttpRetryBackoff;
import com.digiwin.http.client.config.DWHttpPathPredicateDefinition;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.client.utils.DWHttpRetryPredicates;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class DWHttpRetryInfo {
    private String targetId = "unknown";
    private Supplier<Boolean> idempotentSupplier;
    private long previousBackoff;
    private int executionCount = 1;
    private DWHttpRetryDefinition sourceRetryDefinition;
    private int noHTTPResponseExceptionCount = 0;

    public DWHttpRetryInfo(DWHttpPathPredicateDefinition pathPredicateDefinition) {
        this(pathPredicateDefinition, pathPredicateDefinition.getPath(), null);
    }

    public DWHttpRetryInfo(DWHttpPathPredicateDefinition pathPredicateDefinition, String targetId, Supplier<Boolean> idempotentSupplier) {
        Objects.requireNonNull(pathPredicateDefinition);
        this.sourceRetryDefinition = pathPredicateDefinition.getRetry();
        if (this.sourceRetryDefinition == null) {
            this.sourceRetryDefinition = new NullHttpRetryDefinition();
        }
        this.targetId = targetId;
        this.idempotentSupplier = idempotentSupplier == null ? () -> true : idempotentSupplier;
    }

    public DWHttpRetryInfo(DWHttpRetryDefinition retryDefinition) {
        Objects.requireNonNull(retryDefinition);
        this.sourceRetryDefinition = retryDefinition;
        this.targetId = "unknown!";
        this.idempotentSupplier = () -> true;
    }

    public int getRetries() {
        return this.sourceRetryDefinition.getRetries();
    }

    public int increaseExecutionCount() {
        ++this.executionCount;
        return this.executionCount;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public boolean canRetry() {
        return this.getRetries() >= this.executionCount;
    }

    public long getPreviousBackoff() {
        return this.previousBackoff;
    }

    public void setPreviousBackoff(long previousBackoff) {
        this.previousBackoff = previousBackoff;
    }

    public DWHttpRetryBackoff getBackoff() {
        return this.sourceRetryDefinition.getBackoff();
    }

    public boolean matchResponseStatusCode(HttpResponse response) {
        if (response == null) {
            return false;
        }
        int statusCode = response.getStatusLine().getStatusCode();
        boolean match = DWHttpRetryPredicates.matchResponseStatus(this.sourceRetryDefinition.getStatuses(), statusCode);
        return match;
    }

    public boolean matchSuccessResponseBodyKeywords(HttpResponse response) throws IOException {
        RetryConditionMatchedResult matchedResult = this.matchSuccessResponseBodyKeywordsResult(response);
        return matchedResult.isMatched();
    }

    public RetryConditionMatchedResult matchSuccessResponseBodyKeywordsResult(HttpResponse response) throws IOException {
        String body;
        if (this.sourceRetryDefinition.getBodyKeywords().size() == 0) {
            return new RetryConditionMatchedResult(false, null, null);
        }
        HttpEntity httpEntity = response.getEntity();
        if (!(httpEntity instanceof BufferedHttpEntity)) {
            httpEntity = new BufferedHttpEntity(httpEntity);
            response.setEntity(httpEntity);
        }
        if ((body = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8")) == null) {
            return new RetryConditionMatchedResult(false, null, null);
        }
        for (String keyword : this.sourceRetryDefinition.getBodyKeywords()) {
            if (keyword == null || keyword.isEmpty() || !body.contains(keyword)) continue;
            return new RetryConditionMatchedResult(true, body, keyword);
        }
        return new RetryConditionMatchedResult(false, null, null);
    }

    public DWHttpRetryDefinition getSourceRetryDefinition() {
        return this.sourceRetryDefinition;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public boolean isIdempotent() {
        return this.idempotentSupplier.get();
    }

    public boolean markIfItIsNoHTTPResponseException(IOException ioException) {
        if (ioException instanceof NoHttpResponseException && this.noHTTPResponseExceptionCount < this.sourceRetryDefinition.getNoHttpResponseExRetries()) {
            ++this.noHTTPResponseExceptionCount;
            return true;
        }
        return false;
    }

    public int getNoHTTPResponseExceptionCount() {
        return this.noHTTPResponseExceptionCount;
    }

    private static class NullHttpRetryDefinition
    extends DWHttpRetryDefinition {
        private NullHttpRetryDefinition() {
        }

        @Override
        public int getNoHttpResponseExRetries() {
            return 0;
        }

        @Override
        public int getRetries() {
            return 0;
        }

        @Override
        public String getStatuses() {
            return "";
        }

        @Override
        public Set<String> getBodyKeywords() {
            return Collections.emptySet();
        }

        @Override
        public String getMethods() {
            return "";
        }
    }

    public static class RetryConditionMatchedResult {
        private boolean matched = false;
        private String targetAPIRef = null;
        private String condition = null;

        private RetryConditionMatchedResult(boolean matched, String targetAPIRef, String condition) {
            this.matched = matched;
            this.targetAPIRef = targetAPIRef;
            this.condition = condition;
        }

        public boolean isMatched() {
            return this.matched;
        }

        public String getTargetAPIRef() {
            return this.targetAPIRef;
        }

        public String getCondition() {
            return this.condition;
        }
    }
}

