/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.config;

import com.digiwin.http.client.DWHttpRetryBackoff;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWHttpRetryDefinition {
    private Log log = LogFactory.getLog(DWHttpRetryDefinition.class);
    private int noHttpResponseExRetries = 5;
    private int retries = 3;
    private String statuses;
    private Set<String> bodyKeywords;
    private Boolean idempotenceCheckEnabled = null;
    private String methods;
    private DWHttpRetryBackoff backoff;
    private List<String> nonRetriableClasses;

    public int getNoHttpResponseExRetries() {
        return this.noHttpResponseExRetries;
    }

    public void setNoHttpResponseExRetries(int noHttpResponseExRetries) {
        this.noHttpResponseExRetries = noHttpResponseExRetries;
    }

    public int getRetries() {
        return this.retries;
    }

    public DWHttpRetryDefinition setRetries(int count) {
        this.retries = count;
        return this;
    }

    public String getStatuses() {
        return this.statuses;
    }

    public DWHttpRetryDefinition setStatuses(String statuses) {
        this.statuses = statuses;
        return this;
    }

    public DWHttpRetryDefinition setStatusArray(String ... statuses) {
        if (statuses == null) {
            return this;
        }
        this.statuses = String.join((CharSequence)",", statuses);
        return this;
    }

    public Set<String> getBodyKeywords() {
        if (this.bodyKeywords == null) {
            return Collections.emptySet();
        }
        return this.bodyKeywords;
    }

    public void setBodyKeywords(Set<String> bodyKeywords) {
        this.bodyKeywords = bodyKeywords;
    }

    public Boolean isIdempotenceCheckEnabled() {
        return this.idempotenceCheckEnabled;
    }

    public void setIdempotenceCheckEnabled(Boolean idempotenceCheckEnabled) {
        this.idempotenceCheckEnabled = idempotenceCheckEnabled;
    }

    public String getMethods() {
        return this.methods;
    }

    public DWHttpRetryDefinition setMethods(String methods) {
        this.methods = methods;
        return this;
    }

    public DWHttpRetryDefinition setMethodArray(String ... methods) {
        if (methods == null) {
            return this;
        }
        this.methods = String.join((CharSequence)",", methods);
        return this;
    }

    public DWHttpRetryBackoff getBackoff() {
        return this.backoff;
    }

    public DWHttpRetryDefinition setBackoff(DWHttpRetryBackoff backoff) {
        this.backoff = backoff;
        return this;
    }

    public void setNonRetriableClasses(List<String> nonRetriableClasses) {
        this.nonRetriableClasses = nonRetriableClasses;
    }

    public List<String> getNonRetriableClasses() {
        return this.nonRetriableClasses;
    }

    public Set<Class<? extends Exception>> getExcludeClasses() {
        HashSet<Class<? extends Exception>> excludeClasses = new HashSet<Class<? extends Exception>>();
        if (Objects.nonNull(this.nonRetriableClasses) && !this.nonRetriableClasses.isEmpty()) {
            for (String clazzName : this.nonRetriableClasses) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(clazzName);
                }
                catch (ClassNotFoundException e) {
                    this.log.error((Object)String.format("!!! Can not load class %s !!!", clazzName));
                }
                if (!Objects.nonNull(clazz)) continue;
                excludeClasses.add(clazz);
            }
        }
        return excludeClasses;
    }
}

