/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.spring;

import com.digiwin.http.client.DWHTTPHostAppIdMapMapper;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class DWSpringPKVRuleHostAppIdMapMapper
extends DWHTTPHostAppIdMapMapper {
    private static Log log = LogFactory.getLog(DWSpringPKVRuleHostAppIdMapMapper.class);

    public DWSpringPKVRuleHostAppIdMapMapper(ConfigurableEnvironment configurableEnvironment) {
        super(DWSpringPKVRuleHostAppIdMapMapper.createHostAppIdMap(configurableEnvironment));
    }

    private DWSpringPKVRuleHostAppIdMapMapper(Map<String, String> appIdHostMap) {
        super(appIdHostMap);
    }

    private static Map<String, String> createHostAppIdMap(ConfigurableEnvironment configurableEnvironment) {
        TreeMap<String, String> hostAppIdMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        HashSet urlPropertySet = new HashSet();
        for (PropertySource propertySource : configurableEnvironment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            String[] propertyNames = ((EnumerablePropertySource)propertySource).getPropertyNames();
            urlPropertySet.addAll(Arrays.stream(propertyNames).filter(n -> n.endsWith("Url")).collect(Collectors.toSet()));
        }
        String suffix = "Url";
        for (String urlProperty : urlPropertySet) {
            if (urlProperty == null || !urlProperty.endsWith(suffix)) continue;
            String appId = urlProperty.substring(0, urlProperty.length() - suffix.length());
            try {
                String host = new URI(configurableEnvironment.getProperty(urlProperty)).getHost();
                if (host == null) continue;
                hostAppIdMap.put(appId, host);
            }
            catch (Throwable e) {
                log.warn((Object)String.format("createHostAppIdMap analyze key=%s failed.", urlProperty));
            }
        }
        log.info((Object)String.format("HTTP Retry Host and App ID mapping map(size=%s) = %s", hostAppIdMap.size(), hostAppIdMap));
        return hostAppIdMap;
    }
}

