/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWAPIResponseRetryStrategy;
import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.event.DWHttpRetryEvent;
import com.digiwin.http.context.DWHttpContextUtils;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

public class DWDefaultAPIResponseRetryStrategy
implements DWAPIResponseRetryStrategy {
    private static final Log log = LogFactory.getLog(DWDefaultAPIResponseRetryStrategy.class);
    private DWHttpRetryManager retryManager;

    public DWDefaultAPIResponseRetryStrategy(DWHttpRetryManager retryManager) {
        Objects.requireNonNull(retryManager, "retryManager can not be null!");
        this.retryManager = retryManager;
    }

    private boolean fireRetryEvent(DWHttpRetryInfo retryInfo, HttpContext httpContext, HttpResponse response) {
        DWHttpRetryEvent retryEvent = this.retryManager.fireBeforeRetryEvent(retryInfo, httpContext, response);
        if (retryEvent.isStop()) {
            log.debug((Object)("DAP Response Retry Strategy > STOP RETRY! reason = " + retryEvent.getStopReason()));
            return false;
        }
        return true;
    }

    private boolean beforeRetry(DWHttpRetryInfo retryInfo, int executionCount, HttpContext context, HttpResponse response) {
        if (!retryInfo.canRetry()) {
            log.debug((Object)("DAP Response Retry Strategy > STOP RETRY! retry(count=" + retryInfo.getRetries() + ") limit has been reached."));
            return false;
        }
        boolean idempotent = retryInfo.isIdempotent();
        log.info((Object)("DAP Response Retry Strategy > retrieve target API idempotent = " + idempotent));
        if (!idempotent) {
            log.info((Object)String.format("DAP Response Retry Strategy > STOP RETRY! The target service[%s] is not idempotent.", retryInfo.getTargetId()));
            return false;
        }
        boolean retry = this.fireRetryEvent(retryInfo, context, response);
        if (retry) {
            String backoffType = "none";
            long backoffTime = 0L;
            if (retryInfo.getBackoff() != null) {
                backoffTime = retryInfo.getBackoff().calculate(executionCount, retryInfo.getPreviousBackoff());
                backoffType = retryInfo.getBackoff().getClass().getSimpleName();
            }
            HttpRequest request = DWHttpContextUtils.getRequest(context);
            log.info((Object)String.format("DAP Response Retry Strategy > READY TO RETRY [exeCount=%s, <%s>backoff=%s, url=%s]", executionCount, backoffType, backoffTime, request.getRequestLine().getUri()));
            if (backoffTime > 0L) {
                try {
                    Thread.sleep(backoffTime);
                }
                catch (InterruptedException e) {
                    log.warn((Object)"DWDefaultAPIResponseRetryStrategy.beforeRetry backoff failed!", (Throwable)e);
                }
            }
            retryInfo.increaseExecutionCount();
        }
        return retry;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        DWHttpRetryInfo retryInfo = this.retryManager.getRetryInfo(context);
        if (retryInfo == null) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 200) {
            try {
                DWHttpRetryInfo.RetryConditionMatchedResult matchedResult = retryInfo.matchSuccessResponseBodyKeywordsResult(response);
                if (matchedResult.isMatched()) {
                    log.debug((Object)String.format("DAP Response Retry Strategy > response body(%s) match retry keyword(%s) condition!", matchedResult.getTargetAPIRef(), matchedResult.getCondition()));
                    return this.beforeRetry(retryInfo, executionCount, context, response);
                }
            }
            catch (IOException e) {
                log.warn((Object)"DWDefaultAPIResponseRetryStrategy retryRequest failed!", (Throwable)e);
            }
        } else if (retryInfo.matchResponseStatusCode(response)) {
            log.debug((Object)String.format("DAP Response Retry Strategy > response status=%s match retry statusCode condition!", response.getStatusLine().getStatusCode()));
            return this.beforeRetry(retryInfo, executionCount, context, response);
        }
        return false;
    }

    public long getRetryInterval() {
        return 0L;
    }
}

