/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.client.event.DWHttpRetryEvent;
import com.digiwin.http.client.exception.DWHttpRetryIOException;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class DWDefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private Log log = LogFactory.getLog(DWDefaultHttpRequestRetryHandler.class);
    private final Set<Class<? extends IOException>> nonRetriableClasses = new HashSet<Class<? extends IOException>>();
    private DWHttpRetryManager retryManager;

    public DWDefaultHttpRequestRetryHandler() {
        this((DWHttpRetryManager)null);
    }

    public DWDefaultHttpRequestRetryHandler(DWHttpRetryManager retryManager) {
        this(Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class));
        this.retryManager = retryManager;
    }

    private DWHttpRetryManager getRetryManager() {
        return this.retryManager == null ? DWHttpRetryManager.getInstance() : this.retryManager;
    }

    public DWDefaultHttpRequestRetryHandler(Collection<Class<? extends IOException>> clazzes) {
        for (Class<? extends IOException> clazz : clazzes) {
            this.nonRetriableClasses.add(clazz);
        }
    }

    private int markIfItIsNoHTTPResponseException(IOException exception, int executionCount, DWHttpRetryInfo retryInfo) {
        if (retryInfo.markIfItIsNoHTTPResponseException(exception)) {
            this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest NoHTTPResponseException encountered(count = %s)!", retryInfo.getNoHTTPResponseExceptionCount()));
            int count = retryInfo.getNoHTTPResponseExceptionCount();
            if (count % 3 == 0) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    this.log.warn((Object)"DWDefaultHttpRequestRetryHandler.markIfItIsNoHTTPResponseException sleep failed!", (Throwable)e);
                }
            }
            return executionCount - retryInfo.getNoHTTPResponseExceptionCount();
        }
        return executionCount;
    }

    private boolean fireRetryEvent(DWHttpRetryInfo retryInfo, HttpContext httpContext, IOException ioException) {
        DWHttpRetryEvent retryEvent = this.getRetryManager().fireBeforeRetryEvent(retryInfo, httpContext, ioException);
        if (retryEvent.isStop()) {
            this.log.debug((Object)("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! reason = " + retryEvent.getStopReason()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        void var8_15;
        DWHttpRetryInfo retryInfo = this.getRetryManager().getRetryInfo(exception, context);
        if (retryInfo == null) {
            return false;
        }
        if ((executionCount = this.markIfItIsNoHTTPResponseException(exception, executionCount, retryInfo)) > retryInfo.getRetries()) {
            this.log.debug((Object)("DWDefaultHttpRequestRetryHandler STOP RETRY! retry(count=" + retryInfo.getRetries() + ") limit has been reached."));
            return false;
        }
        if (exception instanceof NoHttpResponseException) {
            return this.fireRetryEvent(retryInfo, context, exception);
        }
        DWHttpRetryDefinition retryDefinition = retryInfo.getSourceRetryDefinition();
        if (!retryDefinition.isRetryAllIOExceptions()) {
            Set<Class<? extends Exception>> excludeClasses = retryDefinition.getExcludeClasses();
            if (Objects.isNull(excludeClasses) || excludeClasses.isEmpty()) {
                if (this.nonRetriableClasses.contains(exception.getClass())) {
                    this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) is in the default reject list!", exception.getClass().getName()));
                    return false;
                }
                for (Class<Exception> clazz : this.nonRetriableClasses) {
                    if (!clazz.isInstance(exception)) continue;
                    this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) is in the default reject list!", exception.getClass().getName()));
                    return false;
                }
            } else {
                if (excludeClasses.contains(exception.getClass())) {
                    this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) is in the user customized reject list!", exception.getClass().getName()));
                    return false;
                }
                for (Class<Exception> clazz : excludeClasses) {
                    if (!clazz.isInstance(exception)) continue;
                    this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) is in the user customized reject list!", exception.getClass().getName()));
                    return false;
                }
            }
        }
        if (exception instanceof DWHttpRetryIOException) {
            boolean idempotent = retryInfo.isIdempotent();
            this.log.debug((Object)("DWDefaultHttpRequestRetryHandler api idempotent = " + idempotent));
            if (!idempotent) {
                this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target service[%s] is not idempotent.", retryInfo.getTargetId()));
                return false;
            }
        } else {
            this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler no need to check api idempotent for IOException[class=%s, message=%s]", exception.getClass().getName(), exception.getMessage()));
        }
        if (!this.fireRetryEvent(retryInfo, context, exception)) {
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        String string = "none";
        long backoffTime = 0L;
        if (retryInfo.getBackoff() != null) {
            backoffTime = retryInfo.getBackoff().calculate(executionCount, retryInfo.getPreviousBackoff());
            String string2 = retryInfo.getBackoff().getClass().getSimpleName();
        }
        this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest[exeCount=%s, <%s>backoff=%s, url=%s]", executionCount, var8_15, backoffTime, request.getRequestLine().getUri()));
        if (backoffTime > 0L) {
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"DWDefaultHttpRequestRetryHandler.retryRequest backoff failed!", (Throwable)e);
            }
        }
        retryInfo.increaseExecutionCount();
        return true;
    }
}

