/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class DWPathPatternHelper {
    private static boolean useSuffixPatternMatch = false;
    private static final boolean useTrailingSlashMatch = true;
    private static PathMatcher pathMatcher = new AntPathMatcher();
    private static AntPathMatcher caseInsensitivePathMatcher = null;
    private static final List<String> fileExtensions;

    public static String getMatchingPattern(String pattern, String lookupPath) {
        return DWPathPatternHelper.getMatchingPattern(pattern, lookupPath, true);
    }

    public static String getMatchingPattern(String pattern, String lookupPath, boolean caseSensitive) {
        return DWPathPatternHelper.getMatchingPattern((PathMatcher)(caseSensitive ? pathMatcher : caseInsensitivePathMatcher), pattern, lookupPath);
    }

    public static String getMatchingPattern(PathMatcher assignedPathMatcher, String pattern, String lookupPath) {
        if (pattern.equals(lookupPath)) {
            return pattern;
        }
        if (useSuffixPatternMatch) {
            if (!fileExtensions.isEmpty() && lookupPath.indexOf(46) != -1) {
                for (String extension : fileExtensions) {
                    if (!assignedPathMatcher.match(pattern + extension, lookupPath)) continue;
                    return pattern + extension;
                }
            } else {
                boolean hasSuffix;
                boolean bl = hasSuffix = pattern.indexOf(46) != -1;
                if (!hasSuffix && assignedPathMatcher.match(pattern + ".*", lookupPath)) {
                    return pattern + ".*";
                }
            }
        }
        if (assignedPathMatcher.match(pattern, lookupPath)) {
            return pattern;
        }
        if (!pattern.endsWith("/") && assignedPathMatcher.match(pattern + "/", lookupPath)) {
            return pattern + "/";
        }
        return null;
    }

    static {
        caseInsensitivePathMatcher = new AntPathMatcher();
        caseInsensitivePathMatcher.setCaseSensitive(false);
        fileExtensions = new ArrayList<String>();
    }
}

