/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.client.condition.DWHttpRetryConditionMatchResult;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.client.event.DWHttpRetryEvent;
import com.digiwin.http.client.exception.DWHttpRetryIOException;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class DWDefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private Log log = LogFactory.getLog(DWDefaultHttpRequestRetryHandler.class);
    private final Set<Class<? extends IOException>> nonRetriableClasses = new HashSet<Class<? extends IOException>>();
    private DWHttpRetryManager retryManager;

    public DWDefaultHttpRequestRetryHandler() {
        this((DWHttpRetryManager)null);
    }

    public DWDefaultHttpRequestRetryHandler(DWHttpRetryManager retryManager) {
        this(Arrays.asList(InterruptedIOException.class, ConnectException.class, SSLException.class));
        this.retryManager = retryManager;
    }

    private DWHttpRetryManager getRetryManager() {
        return this.retryManager == null ? DWHttpRetryManager.getInstance() : this.retryManager;
    }

    public DWDefaultHttpRequestRetryHandler(Collection<Class<? extends IOException>> clazzes) {
        for (Class<? extends IOException> clazz : clazzes) {
            this.nonRetriableClasses.add(clazz);
        }
    }

    private int markIfItIsNoHTTPResponseException(IOException exception, int executionCount, DWHttpRetryInfo retryInfo) {
        if (retryInfo.markIfItIsNoHTTPResponseException(exception)) {
            this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest NoHTTPResponseException encountered(count = %s)!", retryInfo.getNoHTTPResponseExceptionCount()));
        }
        return executionCount - retryInfo.getNoHTTPResponseExceptionCount();
    }

    private boolean fireRetryEventAndBackoffSleep(DWHttpRetryInfo retryInfo, HttpContext httpContext, int executionCount, IOException ioException) {
        DWHttpRetryEvent retryEvent = this.getRetryManager().fireBeforeRetryEvent(retryInfo, httpContext, ioException);
        if (retryEvent.isStop()) {
            this.log.debug((Object)("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! reason = " + retryEvent.getStopReason()));
            return false;
        }
        this.backoffSleep(retryInfo, httpContext, executionCount);
        return true;
    }

    private void backoffSleep(DWHttpRetryInfo retryInfo, HttpContext context, int executionCount) {
        String backoffType = "none";
        long backoffTime = 0L;
        if (retryInfo.getBackoff() != null) {
            backoffTime = retryInfo.getBackoff().calculate(executionCount, retryInfo.getPreviousBackoff());
            backoffType = retryInfo.getBackoff().getClass().getSimpleName();
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest[exeCount=%s, <%s>backoff=%s, url=%s]", executionCount, backoffType, backoffTime, request.getRequestLine().getUri()));
        if (backoffTime > 0L) {
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"DWDefaultHttpRequestRetryHandler.retryRequest backoff failed!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldRetry(DWHttpRetryInfo retryInfo, IOException exception) {
        boolean rejectInExcludeList;
        DWHttpRetryDefinition retryDefinition = retryInfo.getSourceRetryDefinition();
        String rejectMessage = null;
        if (!retryDefinition.isRetryAllIOExceptions()) {
            Set<Class<? extends Exception>> excludeClasses = retryDefinition.getExcludeClasses();
            if (Objects.isNull(excludeClasses) || excludeClasses.isEmpty()) {
                if (this.nonRetriableClasses.contains(exception.getClass())) {
                    rejectMessage = String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) - contains check - is in the default reject list!", exception.getClass().getName());
                } else {
                    for (Class<? extends IOException> clazz : this.nonRetriableClasses) {
                        if (!clazz.isInstance(exception)) continue;
                        rejectMessage = String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) - isInstance check - is in the default reject list!", exception.getClass().getName());
                    }
                }
            } else {
                if (this.getRetryManager().getRetryProperties().isForceToRetryNoHttpResponseException() && exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (this.getRetryManager().getRetryProperties().isForceToRetryUnknownHostException() && exception instanceof UnknownHostException) {
                    return true;
                }
                if (excludeClasses.contains(exception.getClass())) {
                    rejectMessage = String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) is in the user customized reject list!", exception.getClass().getName());
                } else {
                    for (Class<Exception> clazz : excludeClasses) {
                        if (!clazz.isInstance(exception)) continue;
                        rejectMessage = String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target exception(%s) is in the user customized reject list!", exception.getClass().getName());
                    }
                }
            }
        }
        boolean bl = rejectInExcludeList = rejectMessage != null;
        if (exception instanceof DWHttpRetryIOException) {
            boolean idempotent = retryInfo.getIdempotenceIfNotGETAndEnabled();
            this.log.debug((Object)("DWDefaultHttpRequestRetryHandler api idempotent = " + idempotent));
            if (!idempotent) {
                this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target service[%s] is not idempotent.", retryInfo.getTargetId()));
                return false;
            }
        } else {
            DWHttpRetryConditionMatchResult matchResult = retryInfo.matchCondition(exception);
            if (matchResult != null) {
                void var7_14;
                String string = "";
                if (rejectInExcludeList) {
                    String string2 = "exception is in reject list, but>";
                }
                String matchConditionMessage = String.format("DWDefaultHttpRequestRetryHandler %s check condition name=%s, reason=%s, checkIdempotence=%s]", var7_14, matchResult.getConditionName(), matchResult.getReason(), matchResult.checkIdempotence());
                this.log.debug((Object)matchConditionMessage);
                if (matchResult.checkIdempotence()) {
                    boolean idempotent = retryInfo.getIdempotenceIfNotGETAndEnabled(matchResult.checkIdempotence());
                    this.log.debug((Object)("DWDefaultHttpRequestRetryHandler condition require check api idempotent = " + idempotent));
                    if (!idempotent) {
                        this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest STOP RETRY! The target service[%s] is not idempotent.", retryInfo.getTargetId()));
                        return false;
                    }
                }
            } else {
                if (rejectInExcludeList) {
                    this.log.debug(rejectMessage);
                    return false;
                }
                this.log.debug((Object)String.format("DWDefaultHttpRequestRetryHandler no need to check api idempotent for IOException[class=%s, message=%s]", exception.getClass().getName(), exception.getMessage()));
            }
        }
        return true;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        DWHttpRetryInfo retryInfo = this.getRetryManager().getRetryInfo(exception, context);
        if (retryInfo == null) {
            return false;
        }
        int executionCountWithoutExtraRetry = this.markIfItIsNoHTTPResponseException(exception, executionCount, retryInfo);
        if (executionCountWithoutExtraRetry > retryInfo.getRetries()) {
            this.log.debug((Object)("DWDefaultHttpRequestRetryHandler STOP RETRY! retry(count=" + retryInfo.getRetries() + ") limit has been reached."));
            return false;
        }
        boolean countRetry = true;
        if (exception instanceof NoHttpResponseException) {
            countRetry = retryInfo.isNoHTTPResponseExExtraRetriesLimitReached();
        } else if (!this.shouldRetry(retryInfo, exception)) {
            return false;
        }
        if (!this.fireRetryEventAndBackoffSleep(retryInfo, context, executionCount, exception)) {
            return false;
        }
        if (countRetry) {
            retryInfo.increaseExecutionCount();
        }
        return true;
    }
}

