/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWAppIdProvider;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DWAppUriUtils {
    public static final String PROPERTY_PREFIX_OTHER_DAP_URL = "OtherDapUrl";
    public static final String PROPERTY_SUFFIX_APP_URL = "Url";

    private static String getURIString(String uriPropertyKey) {
        String baseUrl = DWApplicationConfigUtils.getProperty((String)uriPropertyKey);
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new RuntimeException(String.format("property [%s] is null or empty!", uriPropertyKey));
        }
        return baseUrl;
    }

    public static String getIAMUri() throws RuntimeException {
        String originIamUrlKey = DWServiceContext.getContext().getRequestHeader().getOrDefault("origin-iam-url-key", "");
        String crossCloudEnabled = DWApplicationConfigUtils.getProperty((String)"crossCloudEnabled");
        String iamUrl = "";
        if (StringUtils.isNotBlank((CharSequence)originIamUrlKey) && "true".equals(crossCloudEnabled)) {
            iamUrl = DWApplicationConfigUtils.getProperty((String)originIamUrlKey, (String)"");
        }
        if (StringUtils.isBlank((CharSequence)iamUrl)) {
            iamUrl = DWApplicationConfigUtils.getProperty((String)"iamUrl");
        }
        return iamUrl;
    }

    public static String getUri(String appId) throws RuntimeException {
        Objects.requireNonNull(appId);
        if ("iam".equalsIgnoreCase(appId)) {
            return DWAppUriUtils.getIAMUri();
        }
        String key = appId + PROPERTY_SUFFIX_APP_URL;
        return DWAppUriUtils.getURIString(key);
    }

    public static String getUri(DWAppIdProvider provider) throws RuntimeException {
        Objects.requireNonNull(provider);
        String appId = provider.getAppId();
        return DWAppUriUtils.getUri(appId);
    }

    @Deprecated
    public static String getOtherDapUri(String appId) throws RuntimeException {
        Objects.requireNonNull(appId);
        String key = PROPERTY_PREFIX_OTHER_DAP_URL + appId;
        return DWAppUriUtils.getURIString(key);
    }

    @Deprecated
    public static String getOtherDapUri(DWAppIdProvider provider) throws RuntimeException {
        Objects.requireNonNull(provider);
        String appId = provider.getAppId();
        return DWAppUriUtils.getOtherDapUri(appId);
    }
}

