/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWBaseServiceResult;
import com.digiwin.gateway.config.DWHttpConnectionConfig;
import com.digiwin.gateway.config.DWHttpRequestConfig;
import com.digiwin.http.client.DWConnectKeepAliveStrategy;
import com.digiwin.http.client.DWDefaultHttpRequestRetryHandler;
import com.digiwin.http.client.DWHttpResponseInterceptor;
import com.digiwin.http.client.entity.DWHttpResponseEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWHttpUriRequestProxy;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class DWHttpClient {
    private HttpClient httpClient;
    private DWHttpRequestConfig reqConfig;
    private DWHttpConnectionConfig connConfig;

    public DWHttpClient() {
        this((DWHttpConnectionConfig)null, (DWHttpRequestConfig)null);
    }

    public DWHttpClient(DWHttpRequestConfig reqConfig) {
        this((DWHttpConnectionConfig)null, reqConfig);
    }

    public DWHttpClient(DWHttpConnectionConfig connconfig) {
        this(connconfig, null);
    }

    public DWHttpClient(DWHttpConnectionConfig connConfig, DWHttpRequestConfig reqConfig) {
        this(connConfig, reqConfig, null);
    }

    public DWHttpClient(DWHttpConnectionConfig connConfig, DWHttpRequestConfig reqConfig, DefaultConnectionKeepAliveStrategy keepAliveStrategy) {
        this.connConfig = connConfig;
        this.reqConfig = reqConfig;
        this.httpClient = this.buildHttpClient(this, keepAliveStrategy);
    }

    public DWHttpClient(HttpClient client) {
        this(client, null, null);
    }

    public DWHttpClient(HttpClient client, DWHttpRequestConfig reqConfig) {
        this(client, null, reqConfig);
    }

    public DWHttpClient(HttpClient client, DWHttpConnectionConfig connconfig) {
        this(client, connconfig, null);
    }

    public DWHttpClient(HttpClient client, DWHttpConnectionConfig connConfig, DWHttpRequestConfig reqConfig) {
        this(client, connConfig, reqConfig, null);
    }

    public DWHttpClient(HttpClient client, DWHttpConnectionConfig connConfig, DWHttpRequestConfig reqConfig, DefaultConnectionKeepAliveStrategy keepAliveStrategy) {
        this.connConfig = connConfig;
        this.reqConfig = reqConfig;
        if (client == null) {
            this.buildHttpClient(this, keepAliveStrategy);
        } else {
            this.httpClient = client;
        }
    }

    private HttpClient buildHttpClient(DWHttpClient dwHttpClient, DefaultConnectionKeepAliveStrategy keepAliveStrategy) {
        if (dwHttpClient.connConfig == null) {
            dwHttpClient.connConfig = DWHttpConnectionConfig.createDefault();
        }
        if (dwHttpClient.reqConfig == null) {
            dwHttpClient.reqConfig = DWHttpRequestConfig.createDefault();
        }
        this.httpClient = DWHttpClient.createHttpClient(dwHttpClient.connConfig, dwHttpClient.reqConfig, keepAliveStrategy);
        return this.httpClient;
    }

    public static HttpClient createHttpClient(DWHttpConnectionConfig connConfig, DWHttpRequestConfig reqConfig, DefaultConnectionKeepAliveStrategy keepAliveStrategy) {
        if (connConfig == null) {
            connConfig = DWHttpConnectionConfig.createDefault();
        }
        if (reqConfig == null) {
            reqConfig = DWHttpRequestConfig.createDefault();
        }
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.closeIdleConnections(120L, TimeUnit.SECONDS);
        cm.setMaxTotal(connConfig.getMaxTotal());
        cm.setDefaultMaxPerRoute(connConfig.getDefaultMaxPerRoute());
        cm.setValidateAfterInactivity(connConfig.getValidateAfterInactivity());
        RequestConfig requestConfig = reqConfig.convert();
        if (keepAliveStrategy == null) {
            keepAliveStrategy = new DWConnectKeepAliveStrategy();
        }
        CloseableHttpClient httpClient = HttpClients.custom().addInterceptorLast((HttpResponseInterceptor)new DWHttpResponseInterceptor()).setRetryHandler((HttpRequestRetryHandler)new DWDefaultHttpRequestRetryHandler()).setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).setKeepAliveStrategy((ConnectionKeepAliveStrategy)keepAliveStrategy).build();
        return httpClient;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.execute(request, (Supplier<Map<String, String>>)null);
    }

    public HttpResponse execute(HttpUriRequest request, Supplier<Map<String, String>> headerSupplier) throws IOException, ClientProtocolException {
        Map<String, String> headers;
        Objects.requireNonNull(request);
        request = DWHttpUriRequestProxy.createProxy(request);
        if (headerSupplier != null && (headers = headerSupplier.get()) != null) {
            for (Map.Entry<String, String> item : headers.entrySet()) {
                request.addHeader(item.getKey(), item.getValue());
            }
        }
        HttpResponse response = this.httpClient.execute(request);
        return response;
    }

    public <R> R execute(HttpUriRequest request, Class<R> entityClassOfR) throws DWHttpFailedException, IOException, ClientProtocolException {
        return this.execute(request, (Type)entityClassOfR);
    }

    public <R> R execute(HttpUriRequest request, Class<R> entityClassOfR, Supplier<Map<String, String>> headerSupplier) throws DWHttpFailedException, IOException, ClientProtocolException {
        return this.execute(request, (Type)entityClassOfR, headerSupplier);
    }

    public <R> R execute(HttpUriRequest request, Type entityTypeOfR) throws DWHttpFailedException, IOException, ClientProtocolException {
        return this.execute(request, entityTypeOfR, null);
    }

    public <R> R execute(HttpUriRequest request, Type entityTypeOfR, Supplier<Map<String, String>> headerSupplier) throws DWHttpFailedException, IOException, ClientProtocolException {
        Gson gson = DWGsonProvider.getGson();
        String bodyString = this.executeAndGetEntityString(request, headerSupplier);
        if (entityTypeOfR == String.class) {
            return (R)bodyString;
        }
        Object entity = gson.fromJson(bodyString, entityTypeOfR);
        return (R)entity;
    }

    private String executeAndGetEntityString(HttpUriRequest request, Supplier<Map<String, String>> headerSupplier) throws DWHttpFailedException, IOException, ClientProtocolException {
        HttpResponse response = this.execute(request, headerSupplier);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            DWHttpFailedException exception = new DWHttpFailedException((HttpRequest)request, response);
            throw exception;
        }
        String bodyString = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        return bodyString;
    }

    public <T, R extends DWHttpResponseEntity<T>> R executeAndGetDWHttpResponseEntity(HttpUriRequest request, Class<T> resultClassOfT) throws DWHttpFailedException, IOException, ClientProtocolException {
        Type dapEntityType = TypeToken.getParameterized(DWHttpResponseEntity.class, (Type[])new Type[]{resultClassOfT}).getType();
        return (R)((DWHttpResponseEntity)this.execute(request, dapEntityType, DWRequestHeaderUtils::getDapApiRequiredHeaders));
    }

    public <T, R extends DWHttpResponseEntity<T>> R executeAndGetDWHttpResponseEntity(HttpUriRequest request, Type resultTypeOfT) throws DWHttpFailedException, IOException, ClientProtocolException {
        Type dapEntityType = TypeToken.getParameterized(DWHttpResponseEntity.class, (Type[])new Type[]{resultTypeOfT}).getType();
        return (R)((DWHttpResponseEntity)this.execute(request, dapEntityType, DWRequestHeaderUtils::getDapApiRequiredHeaders));
    }

    public <R extends DWBaseServiceResult<?, ?>> R executeAndGetDWServiceResult(HttpUriRequest request, Class<R> serviceResultClassOfR) throws DWHttpFailedException, IOException, ClientProtocolException {
        return this.executeAndGetDWServiceResult(request, (Type)serviceResultClassOfR);
    }

    public <R extends DWBaseServiceResult<?, ?>> R executeAndGetDWServiceResult(HttpUriRequest request, Type serviceResultTypeOfR) throws DWHttpFailedException, IOException, ClientProtocolException {
        R dapEntity = this.executeAndGetDWHttpResponseEntity(request, serviceResultTypeOfR);
        return (R)((DWBaseServiceResult)((DWHttpResponseEntity)dapEntity).getResult());
    }

    public <T, Z, R extends DWBaseServiceResult<T, Z>> R executeAndGetDWServiceResult(HttpUriRequest request, Class<T> successType, Class<Z> dataType) throws DWHttpFailedException, IOException {
        return this.executeAndGetDWServiceResult(request, (Type)successType, (Type)dataType);
    }

    public <T, Z, R extends DWBaseServiceResult<T, Z>> R executeAndGetDWServiceResult(HttpUriRequest request, Type successTypeOfT, Type dataTypeOfZ) throws DWHttpFailedException, IOException {
        Type serviceResultType = TypeToken.getParameterized(DWBaseServiceResult.class, (Type[])new Type[]{successTypeOfT, dataTypeOfZ}).getType();
        return this.executeAndGetDWServiceResult(request, serviceResultType);
    }

    public <T, Z, R extends DWBaseServiceResult<T, Z>> R executeAndGetDWServiceResult(HttpUriRequest request, Class<R> serviceResultType, Class<T> successType, Class<Z> dataType) throws DWHttpFailedException, IOException {
        Type parameterizedType = TypeToken.getParameterized(serviceResultType, (Type[])new Type[]{successType, dataType}).getType();
        return this.executeAndGetDWServiceResult(request, parameterizedType);
    }

    public <R> R executeAndGetDWServiceResultData(HttpUriRequest request, Class<R> dataClassOfR) throws DWHttpFailedException, IOException, ClientProtocolException {
        return this.executeAndGetDWServiceResultData(request, (Type)dataClassOfR);
    }

    public <R> R executeAndGetDWServiceResultData(HttpUriRequest request, Type dataTypeOfR) throws DWHttpFailedException, IOException, ClientProtocolException {
        R serviceResult = this.executeAndGetDWServiceResult(request, (Type)((Object)Object.class), dataTypeOfR);
        return (R)serviceResult.getData();
    }
}

