/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.config.DWAppServiceRetryConfig;
import com.digiwin.http.client.config.DWHttpPathPredicateDefinition;
import com.digiwin.http.client.config.DWHttpRetryDefinition;
import com.digiwin.http.client.config.DWServiceRetryConfigLoader;
import com.digiwin.http.client.exception.DWHttpRetryIOException;
import com.digiwin.http.client.utils.DWHttpRetryPredicates;
import com.digiwin.http.context.DWHttpContextUtils;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.protocol.HttpContext;

public class DWHttpRetryManager {
    private static Log log = LogFactory.getLog(DWHttpRetryManager.class);
    public static List<DWAppServiceRetryConfig> configs = DWServiceRetryConfigLoader.load();

    public static DWHttpRetryInfo getRetryInfo(IOException exception, HttpContext context) {
        if (exception instanceof DWHttpRetryIOException) {
            DWHttpRetryIOException retryEx = (DWHttpRetryIOException)exception;
            return retryEx.getRetryInfo();
        }
        return DWHttpRetryManager.getRetryInfo(context);
    }

    public static DWHttpRetryInfo getRetryInfo(HttpContext context) {
        Boolean hasRetry = DWHttpContextUtils.hasRetry(context);
        if (hasRetry == null) {
            DWHttpRetryManager.updateHasRetryAttribute(context);
        }
        return DWHttpContextUtils.getRetryInfo(context);
    }

    private static boolean updateHasRetryAttribute(HttpContext context) {
        DWHttpRetryInfo retryInfo = DWHttpRetryManager.loadRetryInfo(context);
        boolean hasRetry = DWHttpContextUtils.setRetryInfo(context, retryInfo);
        return hasRetry;
    }

    private static DWHttpRetryInfo loadRetryInfo(HttpContext context) {
        String contextAppId = DWHttpContextUtils.getAppId(context);
        List definitions = configs.stream().filter(config -> Objects.equals(config.getAppId(), contextAppId) && config.isEnable()).flatMap(config -> config.getPaths().stream()).filter(path -> path.isEnable()).collect(Collectors.toList());
        BiPredicate<DWHttpPathPredicateDefinition, HttpContext> predicate = DWHttpRetryPredicates.getDefaultRetryPredicate();
        Optional<DWHttpPathPredicateDefinition> optional = definitions.stream().filter(p -> predicate.test((DWHttpPathPredicateDefinition)p, context)).findFirst();
        if (optional.isPresent()) {
            DWHttpPathPredicateDefinition matchedDefinition = optional.get();
            DWHttpRetryDefinition retryDefinition = matchedDefinition.getRetry();
            DWHttpRetryInfo retryInfo = DWHttpRetryManager.createRetryInfo(matchedDefinition);
            return retryInfo;
        }
        return null;
    }

    private static DWHttpRetryInfo createRetryInfo(DWHttpPathPredicateDefinition pathDefinition) {
        if (pathDefinition == null || pathDefinition.getRetry() == null) {
            return null;
        }
        DWHttpRetryInfo retryInfo = new DWHttpRetryInfo(pathDefinition.getRetry());
        return retryInfo;
    }
}

