/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class DWRequestHeaderUtils {
    public static final String HEADER_STANDARD_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_DAP_API_TOKEN = "token";
    public static final String PROPERTY_IAM_AP_TOKEN = "iamApToken";
    public static final String PROPERTY_SERVER_HTTP_TOKEN_MODE = "serverHttpTokenmode";
    public static final String SERVER_HTTP_TOKEN_MODE_IAM = "IAM";
    public static final String HEADER_IAM_API_USER_TOKEN = "digi-middleware-auth-user";
    public static final String HEADER_IAM_API_APP_TOKEN = "digi-middleware-auth-app";

    public static Map<String, String> getDapApiRequiredHeaders() {
        Locale locale;
        HashMap<String, String> requiredHeaders = new HashMap<String, String>();
        String token = DWServiceContext.getContext().getToken();
        if (token != null && !token.isEmpty()) {
            requiredHeaders.put(HEADER_DAP_API_TOKEN, token);
        }
        if ((locale = DWResourceBundleUtils.getCurrentLocale()) != null) {
            requiredHeaders.put(HEADER_STANDARD_ACCEPT_LANGUAGE, locale.toLanguageTag());
        }
        return requiredHeaders;
    }

    public static Map<String, String> getIamApiRequiredHeaders() {
        Locale locale;
        String token;
        HashMap<String, String> requiredHeaders = new HashMap<String, String>();
        String iamApToken = DWApplicationConfigUtils.getProperty((String)PROPERTY_IAM_AP_TOKEN, (String)"");
        if (iamApToken.isEmpty()) {
            iamApToken = DWServiceContext.getContext().getRequestHeader().getOrDefault(HEADER_IAM_API_APP_TOKEN, "");
        }
        requiredHeaders.put(HEADER_IAM_API_APP_TOKEN, iamApToken);
        String tokenMode = DWApplicationConfigUtils.getProperty((String)PROPERTY_SERVER_HTTP_TOKEN_MODE);
        if (StringUtils.isNotBlank((CharSequence)tokenMode) && tokenMode.equals(SERVER_HTTP_TOKEN_MODE_IAM) && (token = DWServiceContext.getContext().getToken()) != null && !token.isEmpty()) {
            requiredHeaders.put(HEADER_IAM_API_USER_TOKEN, token);
        }
        if ((locale = DWResourceBundleUtils.getCurrentLocale()) != null) {
            requiredHeaders.put(HEADER_STANDARD_ACCEPT_LANGUAGE, locale.toLanguageTag());
        }
        return requiredHeaders;
    }
}

