/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.exception;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class DWExternalAPIHttpFailedException
extends DWException {
    private static Log log = LogFactory.getLog(DWExternalAPIHttpFailedException.class);
    public static String INSTRUCTOR_SOURCE_API = "sourceAPI";

    public DWExternalAPIHttpFailedException(HttpRequest request, HttpResponse response) {
        this.createErrorInstructors(request, response);
    }

    public DWExternalAPIHttpFailedException(String message, HttpRequest request, HttpResponse response) {
        super(message);
        this.createErrorInstructors(request, response);
    }

    public DWExternalAPIHttpFailedException(String errorCode, String message, HttpRequest request, HttpResponse response) {
        super(errorCode, message);
        this.createErrorInstructors(request, response);
    }

    public DWExternalAPIHttpFailedException(String url, int statusCode, String responseBodyString) {
        this.createErrorInstructors(url, statusCode, responseBodyString);
    }

    public DWExternalAPIHttpFailedException(String message, String url, int statusCode, String responseBodyString) {
        super(message);
        this.createErrorInstructors(url, statusCode, responseBodyString);
    }

    public DWExternalAPIHttpFailedException(String errorCode, String message, String url, int statusCode, String responseBodyString) {
        super(errorCode, message);
        this.createErrorInstructors(url, statusCode, responseBodyString);
    }

    public DWExternalAPIHttpFailedException(DWHttpFailedException sourceException) {
        super(sourceException.getMessage(), (Throwable)((Object)sourceException));
        this.createErrorInstructors(sourceException);
    }

    public DWExternalAPIHttpFailedException(String errorCode, DWHttpFailedException sourceException) {
        super(errorCode, sourceException.getMessage(), (Throwable)((Object)sourceException));
        this.createErrorInstructors(sourceException);
    }

    private Map<String, Object> createErrorInstructors(DWHttpFailedException sourceException) {
        String url = sourceException.getRequest().getRequestLine().getUri();
        int statusCode = sourceException.getStatusCode();
        String responseBodyString = sourceException.getEntity(String.class);
        return this.createErrorInstructors(url, statusCode, responseBodyString);
    }

    private Map<String, Object> createErrorInstructors(String url, int status, String responseBodyString) {
        HashMap<String, Object> sourceAPI = new HashMap<String, Object>();
        this.getInstructors().put(INSTRUCTOR_SOURCE_API, sourceAPI);
        sourceAPI.put("url", url);
        sourceAPI.put("status", status);
        sourceAPI.put("response", this.getResponseBodyObject(responseBodyString));
        return sourceAPI;
    }

    private Map<String, Object> createErrorInstructors(HttpRequest request, HttpResponse response) {
        String url = request.getRequestLine().getUri();
        return this.createErrorInstructors(url, response);
    }

    private Map<String, Object> createErrorInstructors(String url, HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        String responseBodyString = this.getResponseBodyString(response);
        return this.createErrorInstructors(url, statusCode, responseBodyString);
    }

    private String getResponseBodyString(HttpResponse response) {
        String bodyString = null;
        try {
            bodyString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            log.error((Object)"DWExternalAPIHttpFailedException can not get response body!", (Throwable)e);
        }
        return bodyString;
    }

    private Object getResponseBodyObject(String responseBodyString) {
        if (responseBodyString == null) {
            return responseBodyString;
        }
        try {
            Map responseMap = (Map)new Gson().fromJson(responseBodyString, Map.class);
            return responseMap;
        }
        catch (Exception e) {
            log.error((Object)"DWExternalAPIHttpFailedException can not get response body!", (Throwable)e);
            return responseBodyString;
        }
    }
}

