/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.config;

import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.http.client.config.DWAppServiceRetryConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DWServiceRetryConfigLoader {
    private static Log log = LogFactory.getLog(DWServiceRetryConfigLoader.class);
    private static String RETRY_CONFIG_FILE_NAME = "service-retry-config.json";
    private static List<DWAppServiceRetryConfig> configs = null;

    public static synchronized List<DWAppServiceRetryConfig> load() {
        return DWServiceRetryConfigLoader.load(false);
    }

    public static synchronized List<DWAppServiceRetryConfig> load(boolean reload) {
        if (!reload && configs != null) {
            return configs;
        }
        ConfigPool pool = ConfigPool.getInstance();
        List<DWAppServiceRetryConfig> platformConfigs = DWServiceRetryConfigLoader.loadRetryConfigs("platform", RETRY_CONFIG_FILE_NAME, () -> pool.getPlatformResource(RETRY_CONFIG_FILE_NAME));
        List<DWAppServiceRetryConfig> applicationConfigs = DWServiceRetryConfigLoader.loadRetryConfigs("application", RETRY_CONFIG_FILE_NAME, () -> pool.getApplicationResource(RETRY_CONFIG_FILE_NAME));
        List uniquePlatformConfigs = platformConfigs.stream().filter(cfg -> applicationConfigs.stream().noneMatch(appCfg -> Objects.equals(cfg.getAppId(), appCfg.getAppId()))).collect(Collectors.toList());
        uniquePlatformConfigs.addAll(applicationConfigs);
        configs = uniquePlatformConfigs;
        return configs;
    }

    private static List<DWAppServiceRetryConfig> loadRetryConfigs(String type, String fileName, Supplier<String> retryConfigContentSupplier) {
        ArrayList retryConfigs = null;
        try {
            String content = retryConfigContentSupplier.get();
            Gson gson = DWGsonProvider.getGson();
            Type configsType = TypeToken.getParameterized(List.class, (Type[])new Type[]{DWAppServiceRetryConfig.class}).getType();
            retryConfigs = (ArrayList)gson.fromJson(content, configsType);
        }
        catch (Exception e) {
            log.error((Object)String.format("DWServiceRetryConfigLoader load type=%s, file=%s failed!", type, fileName), (Throwable)e);
        }
        if (retryConfigs == null) {
            retryConfigs = new ArrayList();
        }
        return retryConfigs;
    }
}

