/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.http.client.DWAppIdProvider;
import java.util.Objects;

public class DWAppUriUtils {
    public static final String PROPERTY_PREFIX_OTHER_DAP_URL = "OtherDapUrl";
    public static final String PROPERTY_SUFFIX_APP_URL = "Url";

    private static String getURIString(String uriPropertyKey) {
        String baseUrl = SpringContextUtils.getEnvironment().getProperty(uriPropertyKey);
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new RuntimeException(String.format("property [%s] is null or empty!", uriPropertyKey));
        }
        return baseUrl;
    }

    public static String getIAMUri() throws RuntimeException {
        String iamUrl = SpringContextUtils.getEnvironment().getProperty("iamUrl");
        return iamUrl;
    }

    public static String getUri(String appId) throws RuntimeException {
        Objects.requireNonNull(appId);
        if ("iam".equalsIgnoreCase(appId)) {
            return DWAppUriUtils.getIAMUri();
        }
        String key = appId + PROPERTY_SUFFIX_APP_URL;
        return DWAppUriUtils.getURIString(key);
    }

    public static String getUri(DWAppIdProvider provider) throws RuntimeException {
        Objects.requireNonNull(provider);
        String appId = provider.getAppId();
        return DWAppUriUtils.getUri(appId);
    }

    @Deprecated
    public static String getOtherDapUri(String appId) throws RuntimeException {
        Objects.requireNonNull(appId);
        String key = PROPERTY_PREFIX_OTHER_DAP_URL + appId;
        return DWAppUriUtils.getURIString(key);
    }

    @Deprecated
    public static String getOtherDapUri(DWAppIdProvider provider) throws RuntimeException {
        Objects.requireNonNull(provider);
        String appId = provider.getAppId();
        return DWAppUriUtils.getOtherDapUri(appId);
    }
}

