/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.context;

import com.digiwin.http.client.DWAppIdProvider;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.lang.reflect.Proxy;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;

public class DWHttpContextUtils {
    private static final String ATTRIBUTE_APPID = "dwhttp.appid";
    private static final String ATTRIBUTE_HAS_RETRY = "dwhttp.hasretry";
    private static final String ATTRIBUTE_RETRY_INFO = "dwhttp.retryinfo";

    public static HttpRequest getRequest(HttpContext context) {
        return (HttpRequest)context.getAttribute("http.request");
    }

    private static void setAppId(HttpContext context, String appId) {
        context.setAttribute(ATTRIBUTE_APPID, (Object)appId);
    }

    public static String getAppId(HttpContext context) {
        String appId = (String)context.getAttribute(ATTRIBUTE_APPID);
        if (appId == null) {
            Header dwappHeader;
            DWAppIdProvider appIdProvider = null;
            HttpRequest request = DWHttpContextUtils.getRequest(context);
            if (request instanceof HttpRequestWrapper) {
                request = ((HttpRequestWrapper)request).getOriginal();
            }
            if (request != null && Proxy.isProxyClass(request.getClass()) && (dwappHeader = request.getFirstHeader("dwapp")) instanceof DWAppIdProvider) {
                appIdProvider = (DWAppIdProvider)dwappHeader;
            }
            if (appIdProvider != null) {
                appId = appIdProvider.getAppId();
            }
            DWHttpContextUtils.setAppId(context, appId);
        }
        return appId;
    }

    private static void setRetry(HttpContext context, boolean retry) {
        context.setAttribute(ATTRIBUTE_HAS_RETRY, (Object)retry);
    }

    public static Boolean hasRetry(HttpContext context) {
        return (Boolean)context.getAttribute(ATTRIBUTE_HAS_RETRY);
    }

    public static boolean setRetryInfo(HttpContext context, DWHttpRetryInfo retryInfo) {
        boolean hasRetry = retryInfo != null;
        DWHttpContextUtils.setRetry(context, hasRetry);
        context.setAttribute(ATTRIBUTE_RETRY_INFO, (Object)retryInfo);
        return hasRetry;
    }

    public static DWHttpRetryInfo getRetryInfo(HttpContext context) {
        return (DWHttpRetryInfo)context.getAttribute(ATTRIBUTE_RETRY_INFO);
    }
}

