/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client.utils;

import com.digiwin.http.client.DWAppIdProvider;
import com.digiwin.http.client.DWAppUriProvider;
import com.digiwin.http.client.utils.DWAppUriUtils;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.aop.framework.ProxyFactory;

public class DWHttpUriRequestProxy
implements MethodInterceptor {
    private boolean initialized = false;
    private URI realUri;
    private String appId;
    private HttpUriRequest sourceRequest;
    private DWAppIdHeader appIdHeader;

    public DWHttpUriRequestProxy(HttpUriRequest sourceRequest) {
        Objects.requireNonNull(sourceRequest);
        this.sourceRequest = sourceRequest;
    }

    private boolean hasAppId() {
        this.initialize();
        return this.appId != null && !this.appId.isEmpty();
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        URI sourceURI = this.sourceRequest.getURI();
        Objects.requireNonNull(sourceURI);
        if (sourceURI.getScheme() != null && "dwapp".equals(sourceURI.getScheme().toLowerCase()) && sourceURI.getHost() != null) {
            this.appId = sourceURI.getHost();
        }
        if (this.appId != null && !this.appId.isEmpty()) {
            this.appIdHeader = new DWAppIdHeader();
            String path = sourceURI.getRawPath();
            String query = sourceURI.getRawQuery();
            String servicePath = path + (query == null ? "" : "?" + query);
            this.realUri = DWHttpUriRequestProxy.covertToRealScheme(this.appIdHeader, (HttpRequest)this.sourceRequest, servicePath);
        }
        this.initialized = true;
    }

    private void clear() {
        this.initialized = false;
        this.realUri = null;
        this.appId = null;
        this.appIdHeader = null;
    }

    private URI getRealURI(Object o, Method getRealURIMethod) throws Throwable {
        this.initialize();
        if (this.realUri == null) {
            return (URI)getRealURIMethod.invoke(o, new Object[0]);
        }
        return this.realUri;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object[] objects = invocation.getArguments();
        Object o = invocation.getThis();
        String methodName = method.getName();
        if ("getFirstHeader".equals(methodName) && objects.length == 1 && objects[0] != null && this.hasAppId()) {
            return this.appIdHeader;
        }
        if ("getURI".equals(methodName)) {
            return this.getRealURI(o, method);
        }
        if ("setURI".equals(methodName)) {
            this.clear();
        }
        return method.invoke(o, objects);
    }

    public static HttpUriRequest createProxy(HttpUriRequest sourceRequest) {
        DWHttpUriRequestProxy interceptor = new DWHttpUriRequestProxy(sourceRequest);
        ProxyFactory factory = new ProxyFactory((Object)sourceRequest);
        factory.addAdvice((Advice)interceptor);
        HttpUriRequest proxy = (HttpUriRequest)factory.getProxy();
        return proxy;
    }

    private static URI covertToRealScheme(DWAppIdHeader appIdHeader, HttpRequest request, String servicePath) {
        DWAppUriProvider appUriProvider = null;
        if (request instanceof HttpRequestWrapper) {
            HttpRequestWrapper wrapper = (HttpRequestWrapper)request;
            return DWHttpUriRequestProxy.covertToRealScheme(appIdHeader, wrapper.getOriginal(), servicePath);
        }
        appUriProvider = request instanceof DWAppUriProvider ? (DWAppUriProvider)request : appIdHeader;
        return DWHttpUriRequestProxy.covertToRealScheme((DWAppIdProvider)appIdHeader, appUriProvider, servicePath);
    }

    private static URI covertToRealScheme(DWAppIdProvider appIdProvider, DWAppUriProvider appUriProvider, String servicePath) {
        String appUri = appUriProvider.getAppUriString(appIdProvider);
        boolean appUriHasSlash = appUri.endsWith("/");
        boolean servicePathHasSlash = servicePath.startsWith("/");
        boolean servicePathOnlyQueryString = servicePath.startsWith("?");
        if (appUriHasSlash && (servicePathOnlyQueryString || servicePathHasSlash)) {
            appUri = appUri.substring(0, appUri.length() - 1);
        } else if (!(appUriHasSlash || servicePathHasSlash || servicePathOnlyQueryString)) {
            appUri = appUri + "/";
        }
        String uriString = appUri + servicePath;
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("DWHttpUriRequestProxy.covertToRealScheme failed!", e);
        }
    }

    public class DWAppIdHeader
    implements Header,
    DWAppIdProvider,
    DWAppUriProvider {
        @Override
        public String getAppId() {
            return DWHttpUriRequestProxy.this.appId;
        }

        @Override
        public String getAppUriString(DWAppIdProvider appIdProvider) {
            return DWAppUriUtils.getUri(this);
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }

        public String getName() {
            return "dwapp";
        }

        public String getValue() {
            return this.getAppId();
        }
    }
}

