/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.client;

import com.digiwin.http.client.DWHttpRetryManager;
import com.digiwin.http.context.DWHttpRetryInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class DWDefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private Log log = LogFactory.getLog(DWDefaultHttpRequestRetryHandler.class);
    private final Set<Class<? extends IOException>> nonRetriableClasses = new HashSet<Class<? extends IOException>>();

    public DWDefaultHttpRequestRetryHandler() {
        this(Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class));
    }

    public DWDefaultHttpRequestRetryHandler(Collection<Class<? extends IOException>> clazzes) {
        for (Class<? extends IOException> clazz : clazzes) {
            this.nonRetriableClasses.add(clazz);
        }
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        DWHttpRetryInfo retryInfo = DWHttpRetryManager.getRetryInfo(exception, context);
        if (retryInfo == null) {
            return false;
        }
        if (executionCount > retryInfo.getRetries()) {
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        long backoffTime = 0L;
        if (retryInfo.getBackoff() != null) {
            backoffTime = retryInfo.getBackoff().calculate(executionCount, retryInfo.getPreviousBackoff());
        }
        this.log.info((Object)String.format("DWDefaultHttpRequestRetryHandler.retryRequest[exeCount=%s, backoff=%s, url=%s]", executionCount, backoffTime, request.getRequestLine().getUri()));
        if (backoffTime > 0L) {
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.warn((Object)"DWDefaultHttpRequestRetryHandler.retryRequest backoff failed!", (Throwable)e);
            }
        }
        retryInfo.increaseExecutionCount();
        return true;
    }
}

