/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.http.context;

import org.apache.http.protocol.HttpContext;

public class DWLoadBalanceUtils {
    private static ThreadLocal<Boolean> loadBalanceLocal = new ThreadLocal();
    private static ThreadLocal<HttpContext> httpContextThreadLocal = new ThreadLocal();

    public static void setLoadBalanceFlag(boolean loadBalanceEnable) {
        loadBalanceLocal.set(loadBalanceEnable);
    }

    public static Boolean getLoadBalanceFlag() {
        return loadBalanceLocal.get();
    }

    public static void resetFlag() {
        loadBalanceLocal.remove();
    }

    public static void setHttpContext(HttpContext httpContext) {
        httpContextThreadLocal.set(httpContext);
    }

    public static HttpContext getHttpContext() {
        return httpContextThreadLocal.get();
    }

    public static void resetHttpContext() {
        httpContextThreadLocal.remove();
    }

    public static void setDecentralized(HttpContext httpContext, boolean decentralized) {
        httpContext.setAttribute("dwhttp.isdecentralized", (Object)decentralized);
    }

    public static void storeSetting(HttpContext storage) {
        storage.setAttribute("dwhttp.loadbalance.store-mark", (Object)true);
        storage.setAttribute("dwhttp.loadbalance.flag", (Object)DWLoadBalanceUtils.getLoadBalanceFlag());
    }

    public static void restoreSetting(HttpContext storage) {
        if (!Boolean.TRUE.equals(storage.getAttribute("dwhttp.loadbalance.store-mark"))) {
            return;
        }
        Object flag = storage.getAttribute("dwhttp.loadbalance.flag");
        if (flag == null) {
            DWLoadBalanceUtils.resetFlag();
        } else if (flag instanceof Boolean) {
            DWLoadBalanceUtils.setLoadBalanceFlag((Boolean)flag);
        }
    }
}

