/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.iam.HttpConnectionManager;
import com.digiwin.iam.HttpRequestLogModel;
import com.digiwin.iam.HttpRequestLogger;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpResponseModel;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class HttpRequester {
    private static final String beanName = "dw-tracingHttpClient";
    private static final boolean isExistTracingHttpClientBean = DWApplicationSpringUtils.getContext().containsBean("dw-tracingHttpClient");

    public static HttpResponseModel submitRequest(HttpRequestModel requestModel) throws Exception {
        HttpRequestLogModel logModel = new HttpRequestLogModel();
        logModel.setUrl(requestModel.getUrl());
        logModel.setRequestHeader(requestModel.getRequestHeader());
        logModel.setRequestBody(requestModel.getRequestBody());
        CloseableHttpClient client = isExistTracingHttpClientBean ? (CloseableHttpClient)DWApplicationSpringUtils.getBean((String)beanName) : HttpConnectionManager.getHttpClient(requestModel);
        HttpRequestBase httpRequest = HttpRequester.generateHttpRequestBase(requestModel);
        logModel.setStartTime(LocalDateTime.now());
        String responseBody = "";
        int httpStatusCode = -1;
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpRequest);){
            httpStatusCode = response.getStatusLine().getStatusCode();
            try (InputStream responseStream = response.getEntity().getContent();){
                if (responseStream != null) {
                    responseBody = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                }
            }
        }
        logModel.setEndTime(LocalDateTime.now());
        logModel.setResponseBody(responseBody);
        logModel.setHttpStatusCode(httpStatusCode);
        HttpRequestLogger.log(logModel);
        HttpResponseModel responseModel = new HttpResponseModel(httpStatusCode, responseBody);
        return responseModel;
    }

    private static HttpRequestBase generateHttpRequestBase(HttpRequestModel requestModel) throws Exception {
        HttpGet httpRequest = null;
        DWRequestMethod requestMethod = requestModel.getRequestMethod();
        if (requestMethod == DWRequestMethod.GET) {
            httpRequest = new HttpGet(requestModel.getUrl());
        } else if (requestMethod == DWRequestMethod.POST) {
            httpRequest = new HttpPost(requestModel.getUrl());
            StringEntity requestEntity = new StringEntity(requestModel.getRequestBody(), "utf-8");
            requestEntity.setContentType(requestModel.getContentType());
            requestEntity.setContentEncoding(requestModel.getEncode());
            ((HttpPost)httpRequest).setEntity((HttpEntity)requestEntity);
        } else {
            throw new DWException(String.format("API platform DWIAM component http method %s not support", requestMethod));
        }
        for (Map.Entry<String, String> header : requestModel.getRequestHeader().entrySet()) {
            httpRequest.addHeader(header.getKey(), header.getValue());
        }
        return httpRequest;
    }
}

