/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.iam.HttpRequestLogModel;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRequestLogger {
    private static final Log log = LogFactory.getLog(HttpRequestLogger.class);
    public static final String LOG_PREFIX = "[" + HttpRequestLogger.class.getName() + "]";

    public static void log(HttpRequestLogModel model) {
        HttpRequestLogger.logRequestURL(model.getUrl());
        HttpRequestLogger.logRequestHeader(model.getRequestHeader());
        HttpRequestLogger.logRequestBody(model.getRequestBody());
        HttpRequestLogger.logStartTime(model.getStartTime());
        HttpRequestLogger.logEndTime(model.getEndTime());
        HttpRequestLogger.logResponseBody(model.getResponseBody());
        HttpRequestLogger.logHttpStatusCode(model.getHttpStatusCode());
    }

    public static void logRequestHeader(Map<String, String> requestHeaders) {
        for (Map.Entry<String, String> header : requestHeaders.entrySet()) {
            log.debug((Object)(LOG_PREFIX + "Request header:" + header.getKey() + ":" + header.getValue()));
        }
    }

    public static void logRequestURL(String url) {
        log.debug((Object)(LOG_PREFIX + "Request url:" + url));
    }

    public static void logRequestBody(String requestBody) {
        log.debug((Object)(LOG_PREFIX + "Request body:" + requestBody));
    }

    public static void logStartTime(LocalDateTime time) {
        log.debug((Object)(LOG_PREFIX + "Request start time:" + time));
    }

    public static void logEndTime(LocalDateTime time) {
        log.debug((Object)(LOG_PREFIX + "Request end time:" + time));
    }

    public static void logResponseBody(String responseBody) {
        log.debug((Object)(LOG_PREFIX + "Response body:" + responseBody));
    }

    public static void logHttpStatusCode(int httpStatusCode) {
        log.debug((Object)(LOG_PREFIX + "Response http status code:" + httpStatusCode));
    }
}

