/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.iam;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.iam.DWIAMProperties;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMCommonService;
import com.digiwin.iam.response.IAMUserInfoResponseModel;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class IAMUserInfoService {
    @Autowired
    IAMCommonService iamCommonService;
    @Autowired
    private DWIAMProperties properties;

    public IAMUserInfoResponseModel getUserBasicInfoById(String userId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new DWArgumentException("userId", "userId \u4e0d\u80fd\u70ba\u7a7a\u3002");
        }
        HttpResponseModel httpResponseModel = this.getUserBasicInfo(userId, null);
        return new IAMUserInfoResponseModel(httpResponseModel);
    }

    public IAMUserInfoResponseModel getUserBasicInfoBySid(String userSid) throws Exception {
        if (StringUtils.isEmpty((CharSequence)userSid)) {
            throw new DWArgumentException("userSid", "userSid \u4e0d\u80fd\u70ba\u7a7a\u3002");
        }
        HttpResponseModel httpResponseModel = this.getUserBasicInfo(null, userSid);
        return new IAMUserInfoResponseModel(httpResponseModel);
    }

    private HttpResponseModel getUserBasicInfo(String userId, String userSid) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            params.put("id", userId);
        }
        if (StringUtils.isNotEmpty((CharSequence)userSid)) {
            params.put("sid", userSid);
        }
        String invokeURL = this.properties.getApiPathUserBasicInfo();
        String token = DWServiceContext.getContext().getToken();
        return this.iamCommonService.invokeIAMWithDWHttpClient(invokeURL, params, token);
    }
}

